% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/favorites.R
\name{get_favorites}
\alias{get_favorites}
\title{get_favorites}
\usage{
get_favorites(user, n = 3000, since_id = NULL, max_id = NULL,
  parse = TRUE, clean_tweets = FALSE, as_double = FALSE, token = NULL)
}
\arguments{
\item{user}{Screen name or user id of target user.}

\item{n}{Specifies the number of records to retrieve. Must be
less than or equal to 200; defaults to 3000, which is the max
number of favorites returned per token. Due to suspended or
deleted content, this function may return fewer tweets than
the desired (n) number.}

\item{since_id}{Returns results with an status_id greater
than (that is, more recent than) the specified status_id.
There are limits to the number of tweets returned by the REST
API. If the limit is hit, since_id is adjusted (by Twitter) to
the oldest ID available.}

\item{max_id}{Returns results with status_id less (older) than or
equal to (if hit limit) the specified status_id.}

\item{parse}{Logical, indicating whether to return parsed
vector or nested list (fromJSON) object. By default,
\code{parse = TRUE} saves you the time [and frustrations]
associated with disentangling the Twitter API return objects.}

\item{clean_tweets}{logical indicating whether to remove non-ASCII
characters in text of tweets. defaults to FALSE.}

\item{as_double}{logical indicating whether to handle ID variables
as double (numeric) class. By default, this is set to FALSE, meaning
ID variables are treated as character vectors. Setting this to
TRUE can provide performance (speed and memory) boost but can also
lead to issues when printing and saving, depending on the format.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find instructions
on how to create tokens and setup an environment variable in the
tokens vignette (in r, send \code{?tokens} to console).}
}
\value{
Tweets data frame.
}
\description{
Returns the 20 most recent Tweets liked by
  the authenticating or specified user.
}
\examples{
\dontrun{
# get ids of users following the president of the US
pres <- get_followers(user = "potus")
pres

# get ids of users following the Environmental Protection Agency
epa <- get_followers(user = "epa")
epa
}
}
\seealso{
Other tweets: \code{\link{get_timeline}},
  \code{\link{lookup_statuses}},
  \code{\link{search_tweets}}, \code{\link{stream_tweets}},
  \code{\link{tweets_data}}
}

