% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{stream_tweets}
\alias{stream_tweets}
\title{stream_tweets}
\usage{
stream_tweets(stream, timeout = 30, token = NULL, file_name = NULL)
}
\arguments{
\item{stream}{Character vector with desired phrases and keywords
used to filter tweets, a comma separated list of desired
user IDs to track, or a set of bounding boxes to track.}

\item{timeout}{Numeric specifying amount of time, in seconds,
to leave connection open while streaming/capturing tweets.
By default, this is set at 30 seconds.}

\item{token}{OAuth token (1.0 or 2.0). By default
\code{token = NULL} fetches a non-exhausted token from
an environment variable.}

\item{file_name}{Character with name of file. By default, this
generates random file name and parses tweets.}
}
\value{
Tweets data returned as a tibble data_frame
}
\description{
Returns public statuses via one of three methods
  described below. By default, this function deciphers which
  method is when processing the \code{stream} argument.

  1. Filtering via a search-like query (up to 400 keywords)
  2. Tracking via vector of user ids (up to 5000 user_ids)
  3. Location via geo coordinates (1-360 degree location boxes)
}
\examples{
\dontrun{
# stream tweets mentioning Hillary Clinton for 60 seconds
hrc <- stream_tweets(stream = "hillaryclinton", timeout = 60)
hrc

# stream tweets mentioning Donald Trump for 60 seconds
djt <- search_tweets(q = "realdonaldtrump", timeout = 60)
djt
}

}
\seealso{
\url{https://stream.twitter.com/1.1/statuses/filter.json}
}

