% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_estimate.R
\name{trim_estimate}
\alias{trim_estimate}
\title{TRIM estimation function}
\usage{
trim_estimate(count, site, year, month, weights, covars, model,
  changepoints, overdisp, serialcor, autodelete, stepwise, covin,
  verbose = FALSE, ...)
}
\arguments{
\item{count}{a numerical vector of count data.}

\item{site}{an integer/numerical/character/factor vector of site identifiers for each count data point}

\item{year}{an integer/numerical vector time points for each count data point.}

\item{month}{an optional integer/character/factor vector of months for each count data point.}

\item{weights}{an optional numerical vector of weights.}

\item{covars}{an optional data frame withcovariates}

\item{model}{a model type selector (1, 2 or 3)}

\item{changepoints}{a numerical vector change points (only for Model 2)}

\item{overdisp}{a flag indicating of overdispersion has to be taken into account.}

\item{serialcor}{a flag indication of autocorrelation has to be taken into account.}

\item{autodelete}{a flag indicating auto-deletion of changepoints with too little observations.}

\item{stepwise}{a flag indicating stepwise refinement of changepoints is to be used.}

\item{covin}{a list of variance-covariance matrices; one per pseudo-site.}

\item{verbose}{flag to enable addtional output during a single run.}
}
\value{
a list of class \code{trim}, that contains all output, statistiscs, etc.
  Usually this information is retrieved by a set of postprocessing functions
}
\description{
TRIM estimation function
}
\keyword{internal}
