% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_lags.R
\name{identify_lags}
\alias{identify_lags}
\title{Identify time gaps in the data collection period}
\usage{
identify_lags(micropem, column = "rh_corrected_nephelometer")
}
\arguments{
\item{micropem}{a R6 micropem object}

\item{column}{by default "rh_corrected_nephelometer",
but could be "nephelometer", the column in which to look for gaps (\code{character}).}
}
\value{
A data.frame with all the rows of measures where the nephelometer measures is
missing with a time to previous missing values smaller than the nephelometer log.
}
\description{
Identify time gaps in the data collection period
}
\examples{
micropem_na <- convert_output(system.file("extdata", "file_with_na.csv",
                                          package = "rtimicropem"))
micropem_na$plot()
identify_lags(micropem_na)

}
