% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg_channel_posts.R
\name{tg_channel_posts}
\alias{tg_channel_posts}
\title{Retrieving a list of publications}
\usage{
tg_channel_posts(
  channel_id = tg_get_channel_id(),
  start_time = Sys.Date() - 15,
  end_time = Sys.Date(),
  hide_forwards = 0,
  hide_deleted = 0
)
}
\arguments{
\item{channel_id}{Channel ID (@username, t.me/username, t.me/joinchat/AAAAABbbbbcccc ... or channel ID in 'TGStat')}

\item{start_time}{Date of publication from}

\item{end_time}{Date of publication to}

\item{hide_forwards}{Hide reposts from search results}

\item{hide_deleted}{Hide deleted posts}
}
\value{
tibble with channel posts
}
\description{
The method allows you to get channel publications according to the specified parameters. Returns channel messages sorted in reverse chronological order (most recent from the top).
}
\examples{
\dontrun{
posts <- tg_channel_posts(
   channel_id = "R4marketing",
   start_time = "2021-11-01 00:00:00",
   end_time = "2021-11-30 23:59:59"
)
}

}
\references{
See also \href{https://api.tgstat.ru/docs/ru/channels/posts.html}{TGStat API Documentation of metrod channels/posts}
}
