% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\alias{run,character-method}
\alias{run,list-method}
\alias{run,SsimObject-method}
\alias{run,BreakpointSession-method}
\title{Run scenarios}
\usage{
run(
  ssimObject,
  scenario = NULL,
  summary = FALSE,
  jobs = 1,
  copyExternalInputs = FALSE,
  transformerName = NULL,
  forceElements = FALSE
)

\S4method{run}{character}(
  ssimObject,
  scenario = NULL,
  summary = FALSE,
  jobs = 1,
  copyExternalInputs = FALSE,
  transformerName = NULL,
  forceElements = FALSE
)

\S4method{run}{list}(
  ssimObject,
  scenario = NULL,
  summary = FALSE,
  jobs = 1,
  copyExternalInputs = FALSE,
  transformerName = NULL,
  forceElements = FALSE
)

\S4method{run}{SsimObject}(
  ssimObject,
  scenario = NULL,
  summary = FALSE,
  jobs = 1,
  copyExternalInputs = FALSE,
  transformerName = NULL,
  forceElements = FALSE
)

\S4method{run}{BreakpointSession}(ssimObject, scenario, summary, jobs, copyExternalInputs, forceElements)
}
\arguments{
\item{ssimObject}{\code{\link{SsimLibrary}}, \code{\link{Project}}, or
\code{\link{Scenario}} object, or a list of Scenarios, or character (i.e.
path to a SsimLibrary on disk)}

\item{scenario}{character, integer, or vector of these. Scenario names or ids.
If \code{NULL} (default), then runs all Scenarios associated with the SsimObject. Note
that integer ids are slightly faster}

\item{summary}{logical. If \code{FALSE} (default) result Scenario objects are returned.
If \code{TRUE} (faster) result Scenario ids are returned}

\item{jobs}{integer. The number of jobs to run. Passed to SyncroSim where
multithreading is handled}

\item{copyExternalInputs}{logical. If \code{FALSE} (default) then a copy of external
input files (e.g. GeoTIFF files) is not created for each job. Otherwise, a
copy of external inputs is created for each job. Applies only when \code{jobs}>1}

\item{transformerName}{character.  The name of the transformer to run (optional)}

\item{forceElements}{logical. If \code{TRUE} then returns a single result Scenario
as a named list; if \code{FALSE} (default) returns a single result Scenario as
a Scenario object. Applies only when \code{summary=FALSE}}
}
\value{
If \code{summary = FALSE}, returns a result Scenario object or a named list
of result Scenarios. The name is the parent Scenario for each result. If
\code{summary = TRUE}, returns summary info for result Scenarios.
}
\description{
Run one or more SyncroSim \code{\link{Scenario}}(s).
}
\details{
Note that breakpoints are ignored unless the SsimObject is a single Scenario.
}
\examples{
\dontrun{
# Install helloworldSpatial package
addPackage("helloworldSpatial")

# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib")

# Set the SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session(printCmd=T)
myLibrary <- ssimLibrary(name = myLibraryName,
                         session = mySession, 
                         package = "helloworldSpatial",
                         template = "example-library",
                         forceUpdate = TRUE)
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Run with default parameters
resultScenario <- run(myScenario)

# Only return summary information
resultScenario <- run(myScenario, summary = TRUE)

# Run with multiprocessing
resultScenario <- run(myScenario, jobs = 6)

# Return results as a named list
resultScenario <- run(myScenario, forceElements = TRUE)
}

}
