% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_meta.R
\name{scto_meta}
\alias{scto_meta}
\alias{scto_catalog}
\title{Read metadata from a SurveyCTO server}
\usage{
scto_meta(auth)

scto_catalog(auth)
}
\arguments{
\item{auth}{\code{\link[=scto_auth]{scto_auth()}} object.}
}
\value{
\code{scto_meta()} returns a nested list of metadata related to forms,
datasets, groups, and publishing information. \code{scto_catalog()} returns a
\code{data.table} with columns \code{type} ("form" or "dataset"), \code{id}, \code{title}, and
version.
}
\description{
These functions read metadata from a SurveyCTO server.
}
\examples{
\dontrun{
auth = scto_auth('scto_auth.txt')
metadata = scto_meta(auth)
catalog = scto_catalog(auth)
}

}
\seealso{
\code{\link[=scto_auth]{scto_auth()}}, \code{\link[=scto_read]{scto_read()}}, \code{\link[=scto_get_form_definitions]{scto_get_form_definitions()}},
\code{\link[=scto_write]{scto_write()}}
}
