% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_write.R
\name{scto_write}
\alias{scto_write}
\title{Upload data to SurveyCTO}
\usage{
scto_write(auth, data, dataset_id, dataset_title)
}
\arguments{
\item{auth}{\code{\link[=scto_auth]{scto_auth()}} object.}

\item{data}{\code{data.frame} to upload.}

\item{dataset_id}{String indicating ID of existing dataset.}

\item{dataset_title}{String indicating title of dataset.}
}
\value{
An object of class \code{\link[httr:response]{httr::response()}}.
}
\description{
This function uses a web POST request to replace an existing dataset on a
SurveyCTO server. The function is in beta, so use with caution.
}
\examples{
\dontrun{
auth = scto_auth('scto_auth.txt')
res = scto_write(auth, data, 'my_dataset', 'My Dataset')
}

}
\seealso{
\code{\link[=scto_auth]{scto_auth()}}, \code{\link[=scto_read]{scto_read()}}, \code{\link[=scto_get_attachments]{scto_get_attachments()}}
}
