/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import java.util.Iterator;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.DiscretizationUtils;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class SGStatisticsNumeric
extends SGStatistics {
    protected double sgMean;
    protected double sgNormalizedMean;
    protected double populationMean;
    protected double populationNormalizedMean;
    protected double populationVariance = Double.NEGATIVE_INFINITY;
    protected double maxValuePopulation;
    protected double minValuePopulation;
    protected double maxValueSG;
    protected double minValueSG;
    protected double sgVariance = Double.NEGATIVE_INFINITY;
    protected double sgStdDeviation = Double.NEGATIVE_INFINITY;
    protected double sumOfTargetValuesPopulation;
    protected double sumOfTargetValuesSG;
    protected double sgMedian;
    protected double populationMedian;

    public SGStatisticsNumeric(SG subgroup) {
        super(subgroup);
    }

    public SGStatisticsNumeric(SG subgroup, Options options) {
        super(subgroup, options);
    }

    @Override
    protected void calculateStatistics() {
        this.minValuePopulation = Double.MAX_VALUE;
        this.maxValuePopulation = Double.MIN_VALUE;
        this.minValueSG = Double.MAX_VALUE;
        this.maxValueSG = Double.MIN_VALUE;
        this.sgMean = 0.0;
        this.populationMean = 0.0;
        SGTarget target = this.subgroup.getTarget();
        SGDescription description = this.subgroup.getSGDescription();
        for (DataRecord instance : this.subgroup.getPopulation()) {
            double val = ((NumericTarget)target).getValue(instance);
            if (!Double.isNaN(val) && this.isSGSelectorSetDefinedInInstance(instance)) {
                this.definedPopulationCount += instance.getWeight();
                this.minValuePopulation = Math.min(this.minValuePopulation, val);
                this.maxValuePopulation = Math.max(this.maxValuePopulation, val);
                this.sumOfTargetValuesPopulation += val * instance.getWeight();
                if (!description.isMatching(instance)) continue;
                this.sumOfTargetValuesSG += val * instance.getWeight();
                this.subgroupSize += instance.getWeight();
                this.minValueSG = Math.min(this.minValuePopulation, val);
                this.maxValueSG = Math.max(this.maxValuePopulation, val);
                continue;
            }
            this.undefinedPopulationCount += instance.getWeight();
        }
        double range = Math.max(Double.MIN_NORMAL, this.maxValuePopulation - this.minValuePopulation);
        this.sgMean = this.sumOfTargetValuesSG / this.subgroupSize;
        this.populationMean = this.sumOfTargetValuesPopulation / this.definedPopulationCount;
        this.sgNormalizedMean = (this.sgMean - this.minValuePopulation) / range;
        this.populationNormalizedMean = (this.populationMean - this.minValuePopulation) / range;
        this.sgVariance = Double.NEGATIVE_INFINITY;
        this.populationVariance = Double.NEGATIVE_INFINITY;
        this.sgStdDeviation = Double.NEGATIVE_INFINITY;
        this.sgMedian = Double.NEGATIVE_INFINITY;
        this.populationMedian = Double.NEGATIVE_INFINITY;
    }

    public double getPopulationMedian() {
        if (Double.isInfinite(this.populationMedian)) {
            this.computeMedian();
        }
        return this.populationMedian;
    }

    private void computeMedian() {
        NumericAttribute targetAttribute = ((NumericTarget)this.subgroup.getTarget()).getAttribute();
        List<DataRecord> sortedRecords = DiscretizationUtils.getSortedDataRecords(this.subgroup.getPopulation(), targetAttribute, false, false);
        if (this.getDefinedPopulationCount() > 0.0) {
            this.populationMedian = this.getDefinedPopulationCount() % 2.0 == 1.0 ? sortedRecords.get((int)this.getDefinedPopulationCount() / 2).getValue(targetAttribute) : (sortedRecords.get((int)this.getDefinedPopulationCount() / 2).getValue(targetAttribute) + sortedRecords.get((int)this.getDefinedPopulationCount() / 2 - 1).getValue(targetAttribute)) / 2.0;
        } else {
            this.populationMean = Double.NaN;
        }
        sortedRecords = DiscretizationUtils.getSortedDataRecords(this.subgroup, targetAttribute, false, false);
        this.sgMedian = this.subgroupSize == 0.0 ? Double.NaN : (this.subgroupSize % 2.0 == 1.0 ? sortedRecords.get((int)(this.subgroupSize / 2.0)).getValue(targetAttribute) : (sortedRecords.get((int)this.subgroupSize / 2).getValue(targetAttribute) + sortedRecords.get((int)this.subgroupSize / 2 - 1).getValue(targetAttribute)) / 2.0);
    }

    public double getSGMedian() {
        if (Double.isInfinite(this.populationMedian)) {
            this.computeMedian();
        }
        return this.sgMedian;
    }

    private void calculateVarianceAndStdVar() {
        double populationDeviation = 0.0;
        double sgDeviation = 0.0;
        Iterator<DataRecord> iter = this.subgroup.getPopulation().instanceIterator();
        while (iter.hasNext()) {
            DataRecord instance = iter.next();
            if (!this.isInstanceDefinedForSubgroupVars(instance)) continue;
            SGTarget target = this.subgroup.getTarget();
            double val = ((NumericTarget)target).getValue(instance);
            populationDeviation += Math.pow(val - this.populationMean, 2.0);
            if (!this.subgroup.getSGDescription().isMatching(instance)) continue;
            sgDeviation += Math.pow(val - this.sgMean, 2.0);
        }
        this.populationVariance = populationDeviation / this.definedPopulationCount;
        this.sgVariance = sgDeviation / this.subgroupSize;
        this.sgStdDeviation = Math.sqrt(this.sgVariance);
    }

    public double getSumOfTargetValuesPopulation() {
        return this.sumOfTargetValuesPopulation;
    }

    public double getSumOfTargetValuesSG() {
        return this.sumOfTargetValuesSG;
    }

    public double getPopulationMean() {
        return this.populationMean;
    }

    public double getPopulationNormalizedMean() {
        return this.populationNormalizedMean;
    }

    public double getPopulationVariance() {
        if (Double.isInfinite(this.sgVariance)) {
            this.calculateVarianceAndStdVar();
        }
        return this.populationVariance;
    }

    public double getSGMean() {
        return this.sgMean;
    }

    public double getSGNormalizedMean() {
        return this.sgNormalizedMean;
    }

    public double getSGVariance() {
        if (Double.isInfinite(this.sgVariance)) {
            this.calculateVarianceAndStdVar();
        }
        return this.sgVariance;
    }

    public double getMaxValuePopulation() {
        return this.maxValuePopulation;
    }

    public double getMinValuePopulation() {
        return this.minValuePopulation;
    }

    @Override
    public String toString() {
        String basic;
        String result = basic = super.toString();
        result = String.valueOf(result) + basic + "Mean (SG): " + this.sgMean + "\n";
        result = String.valueOf(result) + basic + "Mean (Pop): " + this.populationMean + "\n";
        return result;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public double getDeviation() {
        return this.getSGMean() - this.getPopulationMean();
    }

    public double getSgStdDeviation() {
        if (Double.isInfinite(this.sgStdDeviation)) {
            this.calculateVarianceAndStdVar();
        }
        return this.sgStdDeviation;
    }

    public void setSgStdDeviation(double sgStdDeviation) {
        this.sgStdDeviation = sgStdDeviation;
    }

    @Override
    public double getTargetQuantitySG() {
        return this.getSGMean();
    }

    @Override
    public double getTargetQuantityPopulation() {
        return this.getPopulationMean();
    }

    public double getMaxValueSG() {
        return this.maxValueSG;
    }

    public double getMinValueSG() {
        return this.minValueSG;
    }
}

