% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kruskal_test.R
\name{kruskal_test}
\alias{kruskal_test}
\title{Kruskal-Wallis Test}
\usage{
kruskal_test(data, formula, ...)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
numeric variable giving the data values and \code{group} is a factor with
one or multiple levels giving the corresponding groups. For example,
\code{formula = TP53 ~ cancer_group}.}

\item{...}{other arguments to be passed to the function
\code{\link[stats]{kruskal.test}}.}
}
\value{
return a data frame with the following columns: \itemize{ \item
 \code{.y.}: the y variable used in the test. \item \code{n}: sample count.
 \item \code{statistic}: the kruskal-wallis rank sum statistic used to
 compute the p-value. \item \code{p}: p-value. \item \code{method}: the
 statistical test used to compare groups.}
}
\description{
Provides a pipe-friendly framework to perform Kruskal-Wallis
 rank sum test. Wrapper around the function
 \code{\link[stats]{kruskal.test}()}.
}
\examples{
# Load data
#:::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth

# Kruskal-wallis rank sum test
#:::::::::::::::::::::::::::::::::::::::::
df \%>\% kruskal_test(len ~ dose)
}
