// Generated by rstantools.  Do not edit by hand.

/*
    rstanemax is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanemax is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanemax.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_emax_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'emax', line 35, column 2 to column 40)",
                                                      " (in 'emax', line 37, column 2 to column 47)",
                                                      " (in 'emax', line 38, column 2 to column 53)",
                                                      " (in 'emax', line 39, column 2 to column 51)",
                                                      " (in 'emax', line 40, column 2 to column 24)",
                                                      " (in 'emax', line 43, column 2 to column 20)",
                                                      " (in 'emax', line 44, column 2 to column 25)",
                                                      " (in 'emax', line 45, column 2 to column 13)",
                                                      " (in 'emax', line 46, column 2 to column 25)",
                                                      " (in 'emax', line 47, column 2 to column 29)",
                                                      " (in 'emax', line 48, column 2 to column 20)",
                                                      " (in 'emax', line 49, column 2 to column 20)",
                                                      " (in 'emax', line 50, column 2 to column 24)",
                                                      " (in 'emax', line 51, column 2 to column 18)",
                                                      " (in 'emax', line 53, column 2 to column 57)",
                                                      " (in 'emax', line 54, column 26 to column 75)",
                                                      " (in 'emax', line 54, column 2 to column 75)",
                                                      " (in 'emax', line 55, column 28 to column 85)",
                                                      " (in 'emax', line 55, column 2 to column 85)",
                                                      " (in 'emax', line 57, column 2 to column 26)",
                                                      " (in 'emax', line 58, column 2 to column 26)",
                                                      " (in 'emax', line 59, column 2 to column 22)",
                                                      " (in 'emax', line 61, column 4 to column 40)",
                                                      " (in 'emax', line 62, column 4 to column 39)",
                                                      " (in 'emax', line 60, column 16 to line 63, column 3)",
                                                      " (in 'emax', line 60, column 2 to line 63, column 3)",
                                                      " (in 'emax', line 64, column 2 to column 76)",
                                                      " (in 'emax', line 80, column 2 to column 20)",
                                                      " (in 'emax', line 81, column 17 to column 74)",
                                                      " (in 'emax', line 81, column 2 to column 74)",
                                                      " (in 'emax', line 67, column 2 to column 36)",
                                                      " (in 'emax', line 69, column 2 to column 54)",
                                                      " (in 'emax', line 70, column 2 to column 55)",
                                                      " (in 'emax', line 71, column 2 to column 55)",
                                                      " (in 'emax', line 73, column 4 to column 53)",
                                                      " (in 'emax', line 72, column 26 to line 74, column 3)",
                                                      " (in 'emax', line 72, column 2 to line 74, column 3)",
                                                      " (in 'emax', line 76, column 4 to column 59)",
                                                      " (in 'emax', line 75, column 28 to line 77, column 3)",
                                                      " (in 'emax', line 75, column 2 to line 77, column 3)",
                                                      " (in 'emax', line 2, column 2 to column 19)",
                                                      " (in 'emax', line 3, column 20 to column 21)",
                                                      " (in 'emax', line 3, column 2 to column 32)",
                                                      " (in 'emax', line 4, column 9 to column 10)",
                                                      " (in 'emax', line 4, column 2 to column 21)",
                                                      " (in 'emax', line 6, column 8 to column 9)",
                                                      " (in 'emax', line 6, column 2 to column 34)",
                                                      " (in 'emax', line 7, column 8 to column 9)",
                                                      " (in 'emax', line 7, column 2 to column 34)",
                                                      " (in 'emax', line 8, column 8 to column 9)",
                                                      " (in 'emax', line 8, column 2 to column 32)",
                                                      " (in 'emax', line 9, column 2 to column 31)",
                                                      " (in 'emax', line 10, column 2 to column 31)",
                                                      " (in 'emax', line 11, column 2 to column 29)",
                                                      " (in 'emax', line 13, column 2 to column 37)",
                                                      " (in 'emax', line 14, column 2 to column 34)",
                                                      " (in 'emax', line 15, column 2 to column 36)",
                                                      " (in 'emax', line 16, column 2 to column 32)",
                                                      " (in 'emax', line 17, column 2 to column 20)",
                                                      " (in 'emax', line 18, column 2 to column 22)",
                                                      " (in 'emax', line 21, column 2 to column 21)",
                                                      " (in 'emax', line 22, column 2 to column 30)",
                                                      " (in 'emax', line 23, column 2 to column 31)",
                                                      " (in 'emax', line 24, column 2 to column 19)",
                                                      " (in 'emax', line 25, column 2 to column 31)",
                                                      " (in 'emax', line 27, column 2 to column 31)",
                                                      " (in 'emax', line 28, column 2 to column 31)",
                                                      " (in 'emax', line 29, column 2 to column 32)",
                                                      " (in 'emax', line 30, column 2 to column 29)",
                                                      " (in 'emax', line 31, column 2 to column 32)",
                                                      " (in 'emax', line 35, column 20 to column 33)",
                                                      " (in 'emax', line 37, column 8 to column 19)",
                                                      " (in 'emax', line 37, column 21 to column 33)",
                                                      " (in 'emax', line 38, column 8 to column 21)",
                                                      " (in 'emax', line 38, column 23 to column 37)",
                                                      " (in 'emax', line 39, column 8 to column 23)",
                                                      " (in 'emax', line 43, column 9 to column 10)",
                                                      " (in 'emax', line 44, column 9 to column 10)",
                                                      " (in 'emax', line 46, column 9 to column 20)",
                                                      " (in 'emax', line 47, column 9 to column 22)",
                                                      " (in 'emax', line 48, column 9 to column 10)",
                                                      " (in 'emax', line 49, column 9 to column 10)",
                                                      " (in 'emax', line 50, column 9 to column 10)",
                                                      " (in 'emax', line 51, column 9 to column 10)",
                                                      " (in 'emax', line 80, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_emax final : public model_base_crtp<model_emax> {
private:
  int N;
  Eigen::Matrix<double, -1, 1> exposure;
  Eigen::Matrix<double, -1, 1> response;
  std::vector<int> covemax;
  std::vector<int> covec50;
  std::vector<int> cove0;
  int n_covlev_emax;
  int n_covlev_ec50;
  int n_covlev_e0;
  int gamma_fix_flg;
  int e0_fix_flg;
  int emax_fix_flg;
  double gamma_fix_value;
  double e0_fix_value;
  double emax_fix_value;
  double prior_emax_mu;
  double prior_ec50_mu;
  double prior_gamma_mu;
  double prior_e0_mu;
  double prior_sigma_mu;
  double prior_emax_sig;
  double prior_ec50_sig;
  double prior_gamma_sig;
  double prior_e0_sig;
  double prior_sigma_sig;
  int e0_par_2dim__;
  int emax_par_2dim__;
  int gamma_par_1dim__;
 
public:
  ~model_emax() { }
  
  inline std::string model_name() const final { return "model_emax"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_emax(stan::io::var_context& context__,
             unsigned int random_seed__ = 0,
             std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_emax_namespace::model_emax";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 41;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 41;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 41;
      current_statement__ = 41;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 42;
      validate_non_negative_index("exposure", "N", N);
      current_statement__ = 43;
      context__.validate_dims("data initialization","exposure","double",
          context__.to_vec(N));
      exposure = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(exposure, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> exposure_flat__;
        current_statement__ = 43;
        assign(exposure_flat__, nil_index_list(),
          context__.vals_r("exposure"), "assigning variable exposure_flat__");
        current_statement__ = 43;
        pos__ = 1;
        current_statement__ = 43;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 43;
          assign(exposure, cons_list(index_uni(sym1__), nil_index_list()),
            exposure_flat__[(pos__ - 1)], "assigning variable exposure");
          current_statement__ = 43;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 43;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 43;
        current_statement__ = 43;
        check_greater_or_equal(function__, "exposure[sym1__]",
                               exposure[(sym1__ - 1)], 0);}
      current_statement__ = 44;
      validate_non_negative_index("response", "N", N);
      current_statement__ = 45;
      context__.validate_dims("data initialization","response","double",
          context__.to_vec(N));
      response = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(response, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> response_flat__;
        current_statement__ = 45;
        assign(response_flat__, nil_index_list(),
          context__.vals_r("response"), "assigning variable response_flat__");
        current_statement__ = 45;
        pos__ = 1;
        current_statement__ = 45;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 45;
          assign(response, cons_list(index_uni(sym1__), nil_index_list()),
            response_flat__[(pos__ - 1)], "assigning variable response");
          current_statement__ = 45;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 46;
      validate_non_negative_index("covemax", "N", N);
      current_statement__ = 47;
      context__.validate_dims("data initialization","covemax","int",
          context__.to_vec(N));
      covemax = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 47;
      assign(covemax, nil_index_list(), context__.vals_i("covemax"),
        "assigning variable covemax");
      current_statement__ = 47;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 47;
        current_statement__ = 47;
        check_greater_or_equal(function__, "covemax[sym1__]",
                               covemax[(sym1__ - 1)], 1);}
      current_statement__ = 48;
      validate_non_negative_index("covec50", "N", N);
      current_statement__ = 49;
      context__.validate_dims("data initialization","covec50","int",
          context__.to_vec(N));
      covec50 = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 49;
      assign(covec50, nil_index_list(), context__.vals_i("covec50"),
        "assigning variable covec50");
      current_statement__ = 49;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 49;
        current_statement__ = 49;
        check_greater_or_equal(function__, "covec50[sym1__]",
                               covec50[(sym1__ - 1)], 1);}
      current_statement__ = 50;
      validate_non_negative_index("cove0", "N", N);
      current_statement__ = 51;
      context__.validate_dims("data initialization","cove0","int",
          context__.to_vec(N));
      cove0 = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 51;
      assign(cove0, nil_index_list(), context__.vals_i("cove0"),
        "assigning variable cove0");
      current_statement__ = 51;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 51;
        current_statement__ = 51;
        check_greater_or_equal(function__, "cove0[sym1__]",
                               cove0[(sym1__ - 1)], 1);}
      current_statement__ = 52;
      context__.validate_dims("data initialization","n_covlev_emax","int",
          context__.to_vec());
      n_covlev_emax = std::numeric_limits<int>::min();
      
      current_statement__ = 52;
      n_covlev_emax = context__.vals_i("n_covlev_emax")[(1 - 1)];
      current_statement__ = 52;
      current_statement__ = 52;
      check_greater_or_equal(function__, "n_covlev_emax", n_covlev_emax, 1);
      current_statement__ = 53;
      context__.validate_dims("data initialization","n_covlev_ec50","int",
          context__.to_vec());
      n_covlev_ec50 = std::numeric_limits<int>::min();
      
      current_statement__ = 53;
      n_covlev_ec50 = context__.vals_i("n_covlev_ec50")[(1 - 1)];
      current_statement__ = 53;
      current_statement__ = 53;
      check_greater_or_equal(function__, "n_covlev_ec50", n_covlev_ec50, 1);
      current_statement__ = 54;
      context__.validate_dims("data initialization","n_covlev_e0","int",
          context__.to_vec());
      n_covlev_e0 = std::numeric_limits<int>::min();
      
      current_statement__ = 54;
      n_covlev_e0 = context__.vals_i("n_covlev_e0")[(1 - 1)];
      current_statement__ = 54;
      current_statement__ = 54;
      check_greater_or_equal(function__, "n_covlev_e0", n_covlev_e0, 1);
      current_statement__ = 55;
      context__.validate_dims("data initialization","gamma_fix_flg","int",
          context__.to_vec());
      gamma_fix_flg = std::numeric_limits<int>::min();
      
      current_statement__ = 55;
      gamma_fix_flg = context__.vals_i("gamma_fix_flg")[(1 - 1)];
      current_statement__ = 55;
      current_statement__ = 55;
      check_greater_or_equal(function__, "gamma_fix_flg", gamma_fix_flg, 0);
      current_statement__ = 55;
      current_statement__ = 55;
      check_less_or_equal(function__, "gamma_fix_flg", gamma_fix_flg, 1);
      current_statement__ = 56;
      context__.validate_dims("data initialization","e0_fix_flg","int",
          context__.to_vec());
      e0_fix_flg = std::numeric_limits<int>::min();
      
      current_statement__ = 56;
      e0_fix_flg = context__.vals_i("e0_fix_flg")[(1 - 1)];
      current_statement__ = 56;
      current_statement__ = 56;
      check_greater_or_equal(function__, "e0_fix_flg", e0_fix_flg, 0);
      current_statement__ = 56;
      current_statement__ = 56;
      check_less_or_equal(function__, "e0_fix_flg", e0_fix_flg, 1);
      current_statement__ = 57;
      context__.validate_dims("data initialization","emax_fix_flg","int",
          context__.to_vec());
      emax_fix_flg = std::numeric_limits<int>::min();
      
      current_statement__ = 57;
      emax_fix_flg = context__.vals_i("emax_fix_flg")[(1 - 1)];
      current_statement__ = 57;
      current_statement__ = 57;
      check_greater_or_equal(function__, "emax_fix_flg", emax_fix_flg, 0);
      current_statement__ = 57;
      current_statement__ = 57;
      check_less_or_equal(function__, "emax_fix_flg", emax_fix_flg, 1);
      current_statement__ = 58;
      context__.validate_dims("data initialization","gamma_fix_value",
          "double",context__.to_vec());
      gamma_fix_value = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 58;
      gamma_fix_value = context__.vals_r("gamma_fix_value")[(1 - 1)];
      current_statement__ = 58;
      current_statement__ = 58;
      check_greater_or_equal(function__, "gamma_fix_value", gamma_fix_value,
                             0);
      current_statement__ = 59;
      context__.validate_dims("data initialization","e0_fix_value","double",
          context__.to_vec());
      e0_fix_value = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 59;
      e0_fix_value = context__.vals_r("e0_fix_value")[(1 - 1)];
      current_statement__ = 60;
      context__.validate_dims("data initialization","emax_fix_value",
          "double",context__.to_vec());
      emax_fix_value = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 60;
      emax_fix_value = context__.vals_r("emax_fix_value")[(1 - 1)];
      current_statement__ = 61;
      context__.validate_dims("data initialization","prior_emax_mu","double",
          context__.to_vec());
      prior_emax_mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 61;
      prior_emax_mu = context__.vals_r("prior_emax_mu")[(1 - 1)];
      current_statement__ = 62;
      context__.validate_dims("data initialization","prior_ec50_mu","double",
          context__.to_vec());
      prior_ec50_mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 62;
      prior_ec50_mu = context__.vals_r("prior_ec50_mu")[(1 - 1)];
      current_statement__ = 62;
      current_statement__ = 62;
      check_greater_or_equal(function__, "prior_ec50_mu", prior_ec50_mu, 0);
      current_statement__ = 63;
      context__.validate_dims("data initialization","prior_gamma_mu",
          "double",context__.to_vec());
      prior_gamma_mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 63;
      prior_gamma_mu = context__.vals_r("prior_gamma_mu")[(1 - 1)];
      current_statement__ = 63;
      current_statement__ = 63;
      check_greater_or_equal(function__, "prior_gamma_mu", prior_gamma_mu, 0);
      current_statement__ = 64;
      context__.validate_dims("data initialization","prior_e0_mu","double",
          context__.to_vec());
      prior_e0_mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 64;
      prior_e0_mu = context__.vals_r("prior_e0_mu")[(1 - 1)];
      current_statement__ = 65;
      context__.validate_dims("data initialization","prior_sigma_mu",
          "double",context__.to_vec());
      prior_sigma_mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 65;
      prior_sigma_mu = context__.vals_r("prior_sigma_mu")[(1 - 1)];
      current_statement__ = 65;
      current_statement__ = 65;
      check_greater_or_equal(function__, "prior_sigma_mu", prior_sigma_mu, 0);
      current_statement__ = 66;
      context__.validate_dims("data initialization","prior_emax_sig",
          "double",context__.to_vec());
      prior_emax_sig = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 66;
      prior_emax_sig = context__.vals_r("prior_emax_sig")[(1 - 1)];
      current_statement__ = 66;
      current_statement__ = 66;
      check_greater_or_equal(function__, "prior_emax_sig", prior_emax_sig, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization","prior_ec50_sig",
          "double",context__.to_vec());
      prior_ec50_sig = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 67;
      prior_ec50_sig = context__.vals_r("prior_ec50_sig")[(1 - 1)];
      current_statement__ = 67;
      current_statement__ = 67;
      check_greater_or_equal(function__, "prior_ec50_sig", prior_ec50_sig, 0);
      current_statement__ = 68;
      context__.validate_dims("data initialization","prior_gamma_sig",
          "double",context__.to_vec());
      prior_gamma_sig = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 68;
      prior_gamma_sig = context__.vals_r("prior_gamma_sig")[(1 - 1)];
      current_statement__ = 68;
      current_statement__ = 68;
      check_greater_or_equal(function__, "prior_gamma_sig", prior_gamma_sig,
                             0);
      current_statement__ = 69;
      context__.validate_dims("data initialization","prior_e0_sig","double",
          context__.to_vec());
      prior_e0_sig = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 69;
      prior_e0_sig = context__.vals_r("prior_e0_sig")[(1 - 1)];
      current_statement__ = 69;
      current_statement__ = 69;
      check_greater_or_equal(function__, "prior_e0_sig", prior_e0_sig, 0);
      current_statement__ = 70;
      context__.validate_dims("data initialization","prior_sigma_sig",
          "double",context__.to_vec());
      prior_sigma_sig = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 70;
      prior_sigma_sig = context__.vals_r("prior_sigma_sig")[(1 - 1)];
      current_statement__ = 70;
      current_statement__ = 70;
      check_greater_or_equal(function__, "prior_sigma_sig", prior_sigma_sig,
                             0);
      current_statement__ = 71;
      validate_non_negative_index("ec50", "n_covlev_ec50", n_covlev_ec50);
      current_statement__ = 72;
      validate_non_negative_index("e0_par", "n_covlev_e0", n_covlev_e0);
      current_statement__ = 73;
      e0_par_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 73;
      e0_par_2dim__ = (1 - e0_fix_flg);
      current_statement__ = 73;
      validate_non_negative_index("e0_par", "1 - e0_fix_flg", e0_par_2dim__);
      current_statement__ = 74;
      validate_non_negative_index("emax_par", "n_covlev_emax", n_covlev_emax);
      current_statement__ = 75;
      emax_par_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 75;
      emax_par_2dim__ = (1 - emax_fix_flg);
      current_statement__ = 75;
      validate_non_negative_index("emax_par", "1 - emax_fix_flg",
                                  emax_par_2dim__);
      current_statement__ = 76;
      gamma_par_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 76;
      gamma_par_1dim__ = (1 - gamma_fix_flg);
      current_statement__ = 76;
      validate_non_negative_index("gamma_par", "1 - gamma_fix_flg",
                                  gamma_par_1dim__);
      current_statement__ = 77;
      validate_non_negative_index("respHat", "N", N);
      current_statement__ = 78;
      validate_non_negative_index("exposure_exp", "N", N);
      current_statement__ = 79;
      validate_non_negative_index("e0", "n_covlev_e0", n_covlev_e0);
      current_statement__ = 80;
      validate_non_negative_index("emax", "n_covlev_emax", n_covlev_emax);
      current_statement__ = 81;
      validate_non_negative_index("emaxvec", "N", N);
      current_statement__ = 82;
      validate_non_negative_index("ec50vec", "N", N);
      current_statement__ = 83;
      validate_non_negative_index("ec50vec_exp", "N", N);
      current_statement__ = 84;
      validate_non_negative_index("e0vec", "N", N);
      current_statement__ = 85;
      validate_non_negative_index("log_lik", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += n_covlev_ec50;
      num_params_r__ += n_covlev_e0 * e0_par_2dim__;
      num_params_r__ += n_covlev_emax * emax_par_2dim__;
      num_params_r__ += gamma_par_1dim__;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_emax_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> ec50;
      ec50 = Eigen::Matrix<local_scalar_t__, -1, 1>(n_covlev_ec50);
      stan::math::fill(ec50, DUMMY_VAR__);
      
      current_statement__ = 1;
      ec50 = in__.vector(n_covlev_ec50);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(ec50, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(ec50[(sym1__ - 1)], 0, lp__),
            "assigning variable ec50");
        } else {
          current_statement__ = 1;
          assign(ec50, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(ec50[(sym1__ - 1)], 0),
            "assigning variable ec50");
        }}
      std::vector<std::vector<local_scalar_t__>> e0_par;
      e0_par = std::vector<std::vector<local_scalar_t__>>(n_covlev_e0, std::vector<local_scalar_t__>(e0_par_2dim__, DUMMY_VAR__));
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_covlev_e0; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= e0_par_2dim__; ++sym2__) {
          current_statement__ = 2;
          assign(e0_par,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())), in__.scalar(),
            "assigning variable e0_par");}}
      std::vector<std::vector<local_scalar_t__>> emax_par;
      emax_par = std::vector<std::vector<local_scalar_t__>>(n_covlev_emax, std::vector<local_scalar_t__>(emax_par_2dim__, DUMMY_VAR__));
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= n_covlev_emax; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= emax_par_2dim__; ++sym2__) {
          current_statement__ = 3;
          assign(emax_par,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())), in__.scalar(),
            "assigning variable emax_par");}}
      std::vector<local_scalar_t__> gamma_par;
      gamma_par = std::vector<local_scalar_t__>(gamma_par_1dim__, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(gamma_par, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable gamma_par");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(gamma_par, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gamma_par[(sym1__ - 1)], 0, lp__),
            "assigning variable gamma_par");
        } else {
          current_statement__ = 4;
          assign(gamma_par, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gamma_par[(sym1__ - 1)], 0),
            "assigning variable gamma_par");
        }}
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 5;
      sigma = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 5;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> respHat;
      respHat = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(respHat, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> exposure_exp;
      exposure_exp = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(exposure_exp, DUMMY_VAR__);
      
      local_scalar_t__ gamma;
      gamma = DUMMY_VAR__;
      
      Eigen::Matrix<local_scalar_t__, -1, 1> e0;
      e0 = Eigen::Matrix<local_scalar_t__, -1, 1>(n_covlev_e0);
      stan::math::fill(e0, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> emax;
      emax = Eigen::Matrix<local_scalar_t__, -1, 1>(n_covlev_emax);
      stan::math::fill(emax, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> emaxvec;
      emaxvec = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(emaxvec, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> ec50vec;
      ec50vec = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(ec50vec, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> ec50vec_exp;
      ec50vec_exp = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(ec50vec_exp, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> e0vec;
      e0vec = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(e0vec, DUMMY_VAR__);
      
      current_statement__ = 15;
      gamma = (gamma_fix_flg ?
                 stan::math::promote_scalar<local_scalar_t__>(gamma_fix_value)
                 :
                 stan::math::promote_scalar<local_scalar_t__>(gamma_par[
                 (1 - 1)]));
      current_statement__ = 17;
      for (int i = 1; i <= n_covlev_e0; ++i) {
        current_statement__ = 16;
        assign(e0, cons_list(index_uni(i), nil_index_list()),
          (e0_fix_flg ?
             stan::math::promote_scalar<local_scalar_t__>(e0_fix_value) :
             stan::math::promote_scalar<local_scalar_t__>(e0_par[(i - 1)][
             (1 - 1)])), "assigning variable e0");}
      current_statement__ = 19;
      for (int i = 1; i <= n_covlev_emax; ++i) {
        current_statement__ = 18;
        assign(emax, cons_list(index_uni(i), nil_index_list()),
          (emax_fix_flg ?
             stan::math::promote_scalar<local_scalar_t__>(emax_fix_value) :
             stan::math::promote_scalar<local_scalar_t__>(emax_par[(i - 1)][
             (1 - 1)])), "assigning variable emax");}
      current_statement__ = 20;
      assign(emaxvec, nil_index_list(),
        rvalue(emax, cons_list(index_multi(covemax), nil_index_list()),
          "emax"), "assigning variable emaxvec");
      current_statement__ = 21;
      assign(ec50vec, nil_index_list(),
        rvalue(ec50, cons_list(index_multi(covec50), nil_index_list()),
          "ec50"), "assigning variable ec50vec");
      current_statement__ = 22;
      assign(e0vec, nil_index_list(),
        rvalue(e0, cons_list(index_multi(cove0), nil_index_list()), "e0"),
        "assigning variable e0vec");
      current_statement__ = 26;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 23;
        assign(exposure_exp, cons_list(index_uni(i), nil_index_list()),
          pow(exposure[(i - 1)], gamma), "assigning variable exposure_exp");
        current_statement__ = 24;
        assign(ec50vec_exp, cons_list(index_uni(i), nil_index_list()),
          pow(ec50vec[(i - 1)], gamma), "assigning variable ec50vec_exp");}
      current_statement__ = 27;
      assign(respHat, nil_index_list(),
        add(e0vec,
          elt_divide(elt_multiply(emaxvec, exposure_exp),
            add(ec50vec_exp, exposure_exp))), "assigning variable respHat");
      {
        current_statement__ = 31;
        lp_accum__.add(normal_lpdf<propto__>(response, respHat, sigma));
        current_statement__ = 32;
        lp_accum__.add(
          normal_lpdf<propto__>(ec50, prior_ec50_mu, prior_ec50_sig));
        current_statement__ = 33;
        lp_accum__.add(
          normal_lpdf<propto__>(gamma_par, prior_gamma_mu, prior_gamma_sig));
        current_statement__ = 34;
        lp_accum__.add(
          normal_lpdf<propto__>(sigma, prior_sigma_mu, prior_sigma_sig));
        current_statement__ = 37;
        for (int i = 1; i <= n_covlev_e0; ++i) {
          current_statement__ = 35;
          lp_accum__.add(
            normal_lpdf<propto__>(e0_par[(i - 1)], prior_e0_mu, prior_e0_sig));
        }
        current_statement__ = 40;
        for (int i = 1; i <= n_covlev_emax; ++i) {
          current_statement__ = 38;
          lp_accum__.add(
            normal_lpdf<propto__>(emax_par[(i - 1)], prior_emax_mu,
              prior_emax_sig));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_emax_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> ec50;
      ec50 = Eigen::Matrix<double, -1, 1>(n_covlev_ec50);
      stan::math::fill(ec50, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      ec50 = in__.vector(n_covlev_ec50);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
        current_statement__ = 1;
        assign(ec50, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(ec50[(sym1__ - 1)], 0),
          "assigning variable ec50");}
      std::vector<std::vector<double>> e0_par;
      e0_par = std::vector<std::vector<double>>(n_covlev_e0, std::vector<double>(e0_par_2dim__, std::numeric_limits<double>::quiet_NaN()));
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_covlev_e0; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= e0_par_2dim__; ++sym2__) {
          current_statement__ = 2;
          assign(e0_par,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())), in__.scalar(),
            "assigning variable e0_par");}}
      std::vector<std::vector<double>> emax_par;
      emax_par = std::vector<std::vector<double>>(n_covlev_emax, std::vector<double>(emax_par_2dim__, std::numeric_limits<double>::quiet_NaN()));
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= n_covlev_emax; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= emax_par_2dim__; ++sym2__) {
          current_statement__ = 3;
          assign(emax_par,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())), in__.scalar(),
            "assigning variable emax_par");}}
      std::vector<double> gamma_par;
      gamma_par = std::vector<double>(gamma_par_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(gamma_par, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable gamma_par");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(gamma_par, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(gamma_par[(sym1__ - 1)], 0),
          "assigning variable gamma_par");}
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      sigma = in__.scalar();
      current_statement__ = 5;
      sigma = stan::math::lb_constrain(sigma, 0);
      Eigen::Matrix<double, -1, 1> respHat;
      respHat = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(respHat, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> exposure_exp;
      exposure_exp = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(exposure_exp, std::numeric_limits<double>::quiet_NaN());
      
      double gamma;
      gamma = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> e0;
      e0 = Eigen::Matrix<double, -1, 1>(n_covlev_e0);
      stan::math::fill(e0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> emax;
      emax = Eigen::Matrix<double, -1, 1>(n_covlev_emax);
      stan::math::fill(emax, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> emaxvec;
      emaxvec = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(emaxvec, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> ec50vec;
      ec50vec = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(ec50vec, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> ec50vec_exp;
      ec50vec_exp = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(ec50vec_exp, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> e0vec;
      e0vec = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(e0vec, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
        vars__.emplace_back(ec50[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= e0_par_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_covlev_e0; ++sym2__) {
          vars__.emplace_back(e0_par[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= emax_par_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_covlev_emax; ++sym2__) {
          vars__.emplace_back(emax_par[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
        vars__.emplace_back(gamma_par[(sym1__ - 1)]);}
      vars__.emplace_back(sigma);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 15;
      gamma = (gamma_fix_flg ?
                 stan::math::promote_scalar<local_scalar_t__>(gamma_fix_value)
                 :
                 stan::math::promote_scalar<local_scalar_t__>(gamma_par[
                 (1 - 1)]));
      current_statement__ = 17;
      for (int i = 1; i <= n_covlev_e0; ++i) {
        current_statement__ = 16;
        assign(e0, cons_list(index_uni(i), nil_index_list()),
          (e0_fix_flg ?
             stan::math::promote_scalar<local_scalar_t__>(e0_fix_value) :
             stan::math::promote_scalar<local_scalar_t__>(e0_par[(i - 1)][
             (1 - 1)])), "assigning variable e0");}
      current_statement__ = 19;
      for (int i = 1; i <= n_covlev_emax; ++i) {
        current_statement__ = 18;
        assign(emax, cons_list(index_uni(i), nil_index_list()),
          (emax_fix_flg ?
             stan::math::promote_scalar<local_scalar_t__>(emax_fix_value) :
             stan::math::promote_scalar<local_scalar_t__>(emax_par[(i - 1)][
             (1 - 1)])), "assigning variable emax");}
      current_statement__ = 20;
      assign(emaxvec, nil_index_list(),
        rvalue(emax, cons_list(index_multi(covemax), nil_index_list()),
          "emax"), "assigning variable emaxvec");
      current_statement__ = 21;
      assign(ec50vec, nil_index_list(),
        rvalue(ec50, cons_list(index_multi(covec50), nil_index_list()),
          "ec50"), "assigning variable ec50vec");
      current_statement__ = 22;
      assign(e0vec, nil_index_list(),
        rvalue(e0, cons_list(index_multi(cove0), nil_index_list()), "e0"),
        "assigning variable e0vec");
      current_statement__ = 26;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 23;
        assign(exposure_exp, cons_list(index_uni(i), nil_index_list()),
          pow(exposure[(i - 1)], gamma), "assigning variable exposure_exp");
        current_statement__ = 24;
        assign(ec50vec_exp, cons_list(index_uni(i), nil_index_list()),
          pow(ec50vec[(i - 1)], gamma), "assigning variable ec50vec_exp");}
      current_statement__ = 27;
      assign(respHat, nil_index_list(),
        add(e0vec,
          elt_divide(elt_multiply(emaxvec, exposure_exp),
            add(ec50vec_exp, exposure_exp))), "assigning variable respHat");
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(respHat[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(exposure_exp[(sym1__ - 1)]);}
        vars__.emplace_back(gamma);
        for (int sym1__ = 1; sym1__ <= n_covlev_e0; ++sym1__) {
          vars__.emplace_back(e0[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_covlev_emax; ++sym1__) {
          vars__.emplace_back(emax[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(emaxvec[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(ec50vec[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(ec50vec_exp[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(e0vec[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 30;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 29;
        assign(log_lik, cons_list(index_uni(n), nil_index_list()),
          normal_lpdf<false>(response[(n - 1)], respHat[(n - 1)], sigma),
          "assigning variable log_lik");}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> ec50;
      ec50 = Eigen::Matrix<double, -1, 1>(n_covlev_ec50);
      stan::math::fill(ec50, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> ec50_flat__;
        current_statement__ = 1;
        assign(ec50_flat__, nil_index_list(), context__.vals_r("ec50"),
          "assigning variable ec50_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
          current_statement__ = 1;
          assign(ec50, cons_list(index_uni(sym1__), nil_index_list()),
            ec50_flat__[(pos__ - 1)], "assigning variable ec50");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> ec50_free__;
      ec50_free__ = Eigen::Matrix<double, -1, 1>(n_covlev_ec50);
      stan::math::fill(ec50_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
        current_statement__ = 1;
        assign(ec50_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(ec50[(sym1__ - 1)], 0),
          "assigning variable ec50_free__");}
      std::vector<std::vector<double>> e0_par;
      e0_par = std::vector<std::vector<double>>(n_covlev_e0, std::vector<double>(e0_par_2dim__, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> e0_par_flat__;
        current_statement__ = 2;
        assign(e0_par_flat__, nil_index_list(), context__.vals_r("e0_par"),
          "assigning variable e0_par_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= e0_par_2dim__; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= n_covlev_e0; ++sym2__) {
            current_statement__ = 2;
            assign(e0_par,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              e0_par_flat__[(pos__ - 1)], "assigning variable e0_par");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      std::vector<std::vector<double>> emax_par;
      emax_par = std::vector<std::vector<double>>(n_covlev_emax, std::vector<double>(emax_par_2dim__, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> emax_par_flat__;
        current_statement__ = 3;
        assign(emax_par_flat__, nil_index_list(),
          context__.vals_r("emax_par"), "assigning variable emax_par_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= emax_par_2dim__; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= n_covlev_emax; ++sym2__) {
            current_statement__ = 3;
            assign(emax_par,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              emax_par_flat__[(pos__ - 1)], "assigning variable emax_par");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      std::vector<double> gamma_par;
      gamma_par = std::vector<double>(gamma_par_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(gamma_par, nil_index_list(), context__.vals_r("gamma_par"),
        "assigning variable gamma_par");
      std::vector<double> gamma_par_free__;
      gamma_par_free__ = std::vector<double>(gamma_par_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(gamma_par_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(gamma_par[(sym1__ - 1)], 0),
          "assigning variable gamma_par_free__");}
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
        vars__.emplace_back(ec50_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_covlev_e0; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= e0_par_2dim__; ++sym2__) {
          vars__.emplace_back(e0_par[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= n_covlev_emax; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= emax_par_2dim__; ++sym2__) {
          vars__.emplace_back(emax_par[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
        vars__.emplace_back(gamma_par_free__[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("ec50");
    names__.emplace_back("e0_par");
    names__.emplace_back("emax_par");
    names__.emplace_back("gamma_par");
    names__.emplace_back("sigma");
    names__.emplace_back("respHat");
    names__.emplace_back("exposure_exp");
    names__.emplace_back("gamma");
    names__.emplace_back("e0");
    names__.emplace_back("emax");
    names__.emplace_back("emaxvec");
    names__.emplace_back("ec50vec");
    names__.emplace_back("ec50vec_exp");
    names__.emplace_back("e0vec");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(n_covlev_ec50)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_covlev_e0)
                                             ,
                                             static_cast<size_t>(e0_par_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(n_covlev_emax)
                                             ,
                                             static_cast<size_t>(emax_par_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gamma_par_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_covlev_e0)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(n_covlev_emax)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "ec50" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= e0_par_2dim__; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= n_covlev_e0; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "e0_par" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= emax_par_2dim__; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= n_covlev_emax; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "emax_par" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma_par" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "respHat" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "exposure_exp" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "gamma");
      for (int sym1__ = 1; sym1__ <= n_covlev_e0; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "e0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_covlev_emax; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "emax" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "emaxvec" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ec50vec" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ec50vec_exp" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "e0vec" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "ec50" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= e0_par_2dim__; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= n_covlev_e0; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "e0_par" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= emax_par_2dim__; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= n_covlev_emax; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "emax_par" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma_par" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "respHat" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "exposure_exp" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "gamma");
      for (int sym1__ = 1; sym1__ <= n_covlev_e0; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "e0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_covlev_emax; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "emax" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "emaxvec" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ec50vec" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ec50vec_exp" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "e0vec" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"ec50\",\"type\":{\"name\":\"vector\",\"length\":" << n_covlev_ec50 << "},\"block\":\"parameters\"},{\"name\":\"e0_par\",\"type\":{\"name\":\"array\",\"length\":" << n_covlev_e0 << ",\"element_type\":{\"name\":\"array\",\"length\":" << e0_par_2dim__ << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"emax_par\",\"type\":{\"name\":\"array\",\"length\":" << n_covlev_emax << ",\"element_type\":{\"name\":\"array\",\"length\":" << emax_par_2dim__ << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"gamma_par\",\"type\":{\"name\":\"array\",\"length\":" << gamma_par_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"respHat\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"exposure_exp\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"e0\",\"type\":{\"name\":\"vector\",\"length\":" << n_covlev_e0 << "},\"block\":\"transformed_parameters\"},{\"name\":\"emax\",\"type\":{\"name\":\"vector\",\"length\":" << n_covlev_emax << "},\"block\":\"transformed_parameters\"},{\"name\":\"emaxvec\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"ec50vec\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"ec50vec_exp\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"e0vec\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"ec50\",\"type\":{\"name\":\"vector\",\"length\":" << n_covlev_ec50 << "},\"block\":\"parameters\"},{\"name\":\"e0_par\",\"type\":{\"name\":\"array\",\"length\":" << n_covlev_e0 << ",\"element_type\":{\"name\":\"array\",\"length\":" << e0_par_2dim__ << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"emax_par\",\"type\":{\"name\":\"array\",\"length\":" << n_covlev_emax << ",\"element_type\":{\"name\":\"array\",\"length\":" << emax_par_2dim__ << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"gamma_par\",\"type\":{\"name\":\"array\",\"length\":" << gamma_par_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"respHat\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"exposure_exp\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"e0\",\"type\":{\"name\":\"vector\",\"length\":" << n_covlev_e0 << "},\"block\":\"transformed_parameters\"},{\"name\":\"emax\",\"type\":{\"name\":\"vector\",\"length\":" << n_covlev_emax << "},\"block\":\"transformed_parameters\"},{\"name\":\"emaxvec\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"ec50vec\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"ec50vec_exp\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"e0vec\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_emax_namespace::model_emax;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_emax_namespace::profiles__;
}
#endif
#endif
