% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.list.rdeque}
\alias{as.list.rdeque}
\title{Convert an rdeque to a list}
\usage{
\method{as.list}{rdeque}(x, ...)
}
\arguments{
\item{x}{rdeque to convert.}

\item{...}{additional arguments passed to as.list after initial conversion to list.}
}
\value{
a list containing the elements of the rdeqeue in front-to-back order.
}
\description{
Converts an rdeque to a list, where the front of the deque becomes
the first element of the list, the second-from-front the second, and so on.
}
\details{
Runs in \eqn{O(N)} time in the size of the rdeque, but the generated list is pre-allocated for efficiency.
}
\examples{
d <- rdeque()
d <- insert_front(d, "a")
d <- insert_front(d, "b")

dlist <- as.list(d)
print(dlist)
}
\seealso{
\code{\link{as.data.frame.rstack}} and the generic \code{\link{as.list}}.
}

