% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_location_coords.R
\name{get_location_coords}
\alias{get_location_coords}
\title{Get Coordinates/Geometries for Valid Location Keys}
\usage{
get_location_coords(
  location_unit_type,
  location_keys,
  version,
  token,
  large_query_chunk_size = 10,
  large_query_pause = 0,
  limit = NULL,
  verbose = TRUE
)
}
\arguments{
\item{location_unit_type}{Either \code{"coordinates"} (for buffer around single point) or type of geographic location, including: \code{"countries"}, \code{"regions"}, \code{"cities"}, \code{"zips"}, \code{"places"}, \code{"geo_markets"}, \code{"electoral_district"}, or \code{"country_groups"}. See the \href{https://developers.facebook.com/docs/marketing-api/audiences/reference/basic-targeting#location}{Basic Targetting} documentation for more information.}

\item{location_keys}{Key associated with location. Use the \code{get_fb_parameter_ids} function to get location keys; see \href{https://worldbank.github.io/rsocialwatcher/articles/rsocialwatcher-vignette.html#location-ids}{here} for examples.}

\item{version}{API version. e.g., "v19.0"}

\item{token}{Facebook API token}

\item{large_query_chunk_size}{The function will first try to query all locations using one API call. If too many locations are requested, the function will query in chunks. By default, the function will query 10 locations at a time. (Default: 10).}

\item{large_query_pause}{The function will first try to query all locations using one API call. If too many locations are requested, the function will query in chunks. After each query, the \code{large_query_pause} can be set to > 0 to sleep for \code{large_query_pause} seconds in order to not make too many API calls too quickly. (Default: 0).}

\item{limit}{Number of parameter IDs to search for.}

\item{verbose}{If the function needs to make multiple queries to obtain location information for all location keys, print progress. (Default: \code{TRUE}).}
}
\value{
Spatial features dataframe
}
\description{
Get Coordinates/Geometries for Valid Location Keys
}
\examples{
\dontrun{
#### Define version, creation act, and token
VERSION = "enter-version"
TOKEN = "enter-token"

#### Grab locations
loc_sf <- get_location_coords(location_type = "countries",
                                 location_keys = c("US", "MX", "CA"),
                                 version = VERSION,
                                 token = TOKEN)

}
}
