% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{smooth_hypnogram}
\alias{smooth_hypnogram}
\title{Smooth hypnogram epoch, simulating human scorers behaviour.}
\usage{
smooth_hypnogram(hypnogram, event = "N2", neighbors = "REM", count = 2)
}
\arguments{
\item{hypnogram}{A hypnogram dataframe.}

\item{event}{Central stage label.}

\item{neighbors}{Extremities stages labels.}

\item{count}{Number of consecutive central stages.}
}
\value{
A hypnogram dataframe.
}
\description{
Smooth hypnograms epoch, simulating human scorers behaviour.
}
\examples{
hypnogram <- data.frame(begin = as.POSIXlt(
c(1536967800,1536967830,1536967860),origin = "1970-01-01"))
hypnogram$end <- as.POSIXlt(c(1536967830,1536967860,1536967890), 
origin = "1970-01-01")
hypnogram$event = c("REM","N2","REM")
smooth_hypnogram(hypnogram, "N2","REM",1)
}
\references{
Liang, Sheng-Fu, Chin-En Kuo, Yu-Han Hu, Yu-Hsiang Pan, and Yung-Hung Wang. "Automatic stage scoring of single-channel sleep EEG by using multiscale entropy and autoregressive models." IEEE Transactions on Instrumentation and Measurement 61, no. 6 (2012): 1649-1657.
}
