% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring.R
\name{score_psg}
\alias{score_psg}
\title{Score 30 seconds epochs from European Data Format (EDF) files.}
\usage{
score_psg(
  edf,
  channels = c("C3-M2", "C4-M1", "O1-M2", "E1-M2", "E2-M1", "1-2"),
  model = chambon2018(6, 3 * 30 * 70),
  verbose = TRUE
)
}
\arguments{
\item{edf}{Character. European Data Format (EDF) file path.}

\item{channels}{A vector containing the channels names if names differ from `c("C3-M2","C4-M1","O1-M2","E1-M2","E2-M1","1-2")`.}

\item{model}{The Keras model.}

\item{verbose}{Boolean. Display or not status messages.}
}
\value{
A dataframe containing predicted hypnodensity values of the record.
}
\description{
Score 30 seconds epochs from European Data Format (EDF) files.
}
\references{
Chambon, S., Galtier, M., Arnal, P., Wainrib, G. and Gramfort, A. (2018) A Deep Learning Architecture for Temporal Sleep Stage Classification Using Multivariate and Multimodal Time Series. IEEE Trans. on Neural Systems and Rehabilitation Engineering 26:(758-769).

Kemp, B., Värri, A., Rosa, A.C., Nielsen, K.D. and Gade, J., 1992. A simple format for exchange of digitized polygraphic recordings. Electroencephalography and clinical neurophysiology, 82(5), pp.391-393.
}
