% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simsum.R
\name{simsum}
\alias{simsum}
\title{Analyses of simulation studies including Monte Carlo error}
\usage{
simsum(data, estvarname, true, se, methodvar = NULL, ref = NULL,
  df = NULL, dropbig = FALSE, max = 10, semax = 100, level = 0.95,
  by = NULL, mcse = TRUE, sanitise = TRUE, na.rm = TRUE,
  na.pair = TRUE, x = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} in which variable names are interpreted. It has to be in tidy format, e.g. each variable forms a column and each observation forms a row.}

\item{estvarname}{The name of the variable containing the point estimates.}

\item{true}{The true value of the parameter. This is used in calculations of bias and coverage.}

\item{se}{The name of the variable containing the standard errors of the point estimates.}

\item{methodvar}{The name of the variable containing the methods to compare. For instance, methods could be the models compared within a simulation study. Can be \code{NULL}.}

\item{ref}{Specifies the reference method against which relative precision will be calculated. Only useful if \code{methodvar} is specified.}

\item{df}{If specified, a t distribution with \code{df} degrees of freedom is used when calculating coverage and power.}

\item{dropbig}{Specifies that point estimates or standard errors beyond the maximum acceptable values should be dropped.}

\item{max}{Specifies the maximum acceptable absolute value of the point estimates, standardised to mean 0 and SD 1. Defaults to \code{10}.}

\item{semax}{Specifies the maximum acceptable value of the standard error, as a multiple of the mean standard error. Defaults to \code{100}.}

\item{level}{Specifies the confidence level for coverage and power. Defaults to \code{0.95}.}

\item{by}{A vector of variable names to compute performance measures by a list of factors. Factors listed here are the (potentially several) data-generating mechanisms used to simulate data under different scenarios (e.g. sample size, true distribution of a variable, etc.). Can be \code{NULL}.}

\item{mcse}{Reports Monte Carlo standard errors for all performance measures. Defaults to \code{TRUE}.}

\item{sanitise}{Sanitise column names passed to \code{simsum} by removing all dot characters (\code{.}), which could cause problems. Defaults to \code{TRUE}.}

\item{na.rm}{A logical value indicating whether missing values (\code{NA}) should be removed before the computation proceeds. Defaults to \code{TRUE}.}

\item{na.pair}{Removes estimates that have a missing standard error (and vice versa). Defaults to \code{TRUE}.}

\item{x}{Set to \code{TRUE} to include the \code{data} argument (as utilised to compute summary statistics, i.e. applying \code{dropbig}, \code{na.rm}, \code{na.pair}) as a slot. Defaults to \code{FALSE}.}
}
\value{
An object of class \code{simsum}.
}
\description{
\code{simsum} computes performance measures for simulation studies in which each simulated data set yields point estimates by one or more analysis methods. Bias, empirical standard error and precision relative to a reference method can be computed for each method.  If, in addition, model-based standard errors are available then \code{simsum} can compute the average model-based standard error, the relative error in the model-based standard error, the coverage of nominal confidence intervals, and the power to reject a null hypothesis. Monte Carlo errors are available for all estimated quantities.
}
\details{
The following names are not allowed for \code{estvarname}, \code{se}, \code{methodvar}, \code{by}: \code{stat}, \code{est}, \code{mcse}, \code{lower}, \code{upper}.
Calling the function with \code{x = TRUE} is required to produce zip plots (e.g. via the \code{\link[=zip]{zip()}} method). The downside is that the size of the returned object increases considerably, therefore it is set to \code{FALSE} by default. Please note that the \code{data} slot returned when \code{x = TRUE} is obtained according to the value of the arguments \code{dropbig}, \code{na.rm}, \code{na.pair}; all rows with missing values are removed via a call to \code{\link[stats:na.omit]{stats::na.omit()}}.
}
\examples{
data("MIsim")
s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method", ref = "CC")
# If `ref` is not specified, the reference method is inferred
s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method")
}
\references{
White, I.R. 2010. simsum: Analyses of simulation studies including Monte Carlo error. The Stata Journal 10(3): 369-385. \url{http://www.stata-journal.com/article.html?article=st0200}

Morris, T.P, White, I.R. and Crowther, M.J. 2017. Using simulation studies to evaluate statistical methods. \href{https://arxiv.org/abs/1712.03198}{arXiv:1712.03198}
}
