% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records.R
\name{get_order}
\alias{get_order}
\alias{get_order<-}
\alias{get_order<-,records-method}
\alias{get_order<-,records}
\title{Get the slot called order from a \code{records} or an \code{rtoi}}
\usage{
get_order(x)

get_order(x) <- value

\S4method{get_order}{records}(x) <- value
}
\arguments{
\item{x}{a \code{records} or an \code{rtoi} object.}

\item{value}{logical argument. The new value for \code{x}.}
}
\value{
the value of called order
}
\description{
Get the slot called order from a \code{records} or an \code{rtoi}
}
\examples{
\dontrun{
# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

# get the records
rcds <- records(navarre)

# gets a boolean
get_order(rcds)
}
}
