% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sMoveRes.R
\name{sMoveRes}
\alias{sMoveRes}
\title{sMoveRes}
\usage{
sMoveRes(xy, pixel.res)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{pixel.res}{vector of spatial resolutions (unit depends on spatial projection).}
}
\value{
A \emph{list}.
}
\description{
{Tool to support the selection of an adequate satellite spatial resolution. Evaluates how the change
in spatial resolution changes the amount of samples and sample regions based on a set of coordinate pairs.}
}
\details{
{Given a vector of pixel resolutions (\emph{pixel.res}), the function determines the number of unique pixels
and unique pixel regions after their temporal aggregation. For each spatial resolution, the function starts by converting
\emph{xy} to unique pixel coordinates and labels them based on their spatial aggregation. Then, the function counts the number
of samples and sample regions. The output of the function consists of:
\itemize{
 \item{\emph{stats} - Summary statistics reporting on the number of unique samples and sample regions per spatial resolution.}
 \item{\emph{plot} - Plot representing the change in number of samples and sample regions per spatial resolution.}
 \item{\emph{indices} - Indices for each sample in \emph{xy} based on their spatial aggregation within each spatial resolution.}}}
}
\examples{
{

 require(raster)

 # read movement data
 data(shortMove)

 # test function for 5, 10 20 and 30 m
 a.res <- sMoveRes(shortMove, c(5, 10, 20, 30))

}
}
\seealso{
\code{\link{tMoveRes}} \code{\link{specVar}}
}
