# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Gibbs sampler to estimate the rRUM
#'
#' Obtains samples from posterior distributon for the reduced Reparametrized
#' Unified Model (rRUM).
#'
#' @param Y            A `matrix` with \eqn{N} rows and \eqn{J} columns
#'                     indicating the indviduals' responses to each of the
#'                     items.
#' @param Q            A `matrix` with \eqn{J} rows and \eqn{K} columns
#'                     indicating which attributes are required to answer each
#'                     of the items.An entry of 1 indicates attribute \eqn{k}
#'                     is required to answer item \eqn{j}. An entry of one
#'                     indicates attribute \eqn{k} is not required.
#' @param chain_length A `numeric` indicating the number of iterations of
#'                     Gibbs sampler to be run.  Default is set to 10000.
#' @param as           A `numeric`, parameter for the prior distribution of
#'                     `pistar`.  High values as encourage higher values of
#'                     `pistar` and lower values of `rstar`.
#' @param bs           A `numeric`, parameter for the prior distribution of
#'                     `pistar`.  High values as encourage lower values of
#'                     `pistar` and higher values of `rstar`.
#' @param ag           A `numeric`, parameter for the prior distribution of
#'                     `rstar`.  High values as encourage higher values of
#'                     `rstar`.
#' @param bg           A `numeric`, parameter for the prior distribution of
#'                     `pistar`.  High values as encourage lower values of
#'                     `rstar`.
#' @param deltas       A `vector`, parameters for the Dirichlet prior on `pi`.
#'
#' @return A `List`
#'
#' - `PISTAR` A `matrix` where each column represents one draw from the
#'            posterior distribution of pistar.
#' - `RSTAR` A \eqn{J x K x chain_length} `array` where `J` reperesents the
#'           number of items, and `K` represents the number of attributes.
#'           Each slice represents one draw from the posterior distribution
#'           of `rstar`.
#' - `PI` `matrix` where each column reperesents one draw from the posterior
#'        distribution of `pi`.
#' - `ALPHA` An \eqn{N x K x chain_length} `array` where `N` reperesents the
#'           number of individuals, and `K` represents the number of
#'           attributes. Each slice represents one draw from the posterior
#'           distribution of `alpha`.
#' @author 
#' Steven Andrew Culpepper, Aaron Hudson, and James Joseph Balamuta
#' 
#' @template rrum-example
#' @template rrum-references
#' @keywords internal
rrum_helper <- function(Y, Q, delta0, chain_length = 10000L, as = 1, bs = 1, ag = 1, bg = 1) {
    .Call(`_rrum_rrum_helper`, Y, Q, delta0, chain_length, as, bs, ag, bg)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_rrum_RcppExport_registerCCallable', PACKAGE = 'rrum')
})
