% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{validate_country_code}
\alias{validate_country_code}
\title{Validate ISO two-letters country code}
\usage{
validate_country_code(country)
}
\arguments{
\item{country}{[\code{character(1)}]\cr{}
a two-letter country code or \code{AA}, \code{ZZ} or
\code{__} (special country codes for SHERPA/RoMEO)}
}
\value{
\code{TRUE} if the country code is valid, errors otherwise
}
\description{
If available uses \code{\link[ISOcodes:ISO_3166]{ISOcodes::ISO_3166}} to validate country code.
Otherwise assume that the code is valid as long as it is a two-letter code or
\code{__}. See \code{\link[=rr_publisher_country]{rr_publisher_country()}} for use of country codes.
}
\keyword{internal}
