/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.io.CharStream;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.io.InputStreamBuffered;

public final class StreamUTF8
extends Reader
implements CharStream {
    private InputStreamBuffered input;

    public StreamUTF8(InputStream in) {
        if (in instanceof InputStreamBuffered) {
            this.input = (InputStreamBuffered)in;
            return;
        }
        this.input = new InputStreamBuffered(in);
    }

    public StreamUTF8(InputStreamBuffered in) {
        this.input = in;
    }

    public boolean ready() throws IOException {
        return this.input.available() > 0;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void closeStream() {
        IO.close(this.input);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            int x = this.read();
            if (x == -1) {
                if (i == off) {
                    return -1;
                }
                return i - off;
            }
            cbuf[i] = (char)x;
        }
        return len;
    }

    public final int read() throws IOException {
        return StreamUTF8.advance(this.input);
    }

    public final int advance() {
        return StreamUTF8.advance(this.input);
    }

    public static final int advance(InputStreamBuffered input) {
        int x = input.advance();
        return StreamUTF8.advance(input, x);
    }

    public static final int advance(InputStreamBuffered input, int x) {
        if (x == -1) {
            return x;
        }
        if (x < 127) {
            return x;
        }
        if ((x & 0xE0) == 192) {
            return StreamUTF8.readMultiBytes(input, x & 0x1F, 2);
        }
        if ((x & 0xF0) == 224) {
            return StreamUTF8.readMultiBytes(input, x & 0xF, 3);
        }
        int y = -2;
        if ((x & 0xF8) == 240) {
            y = StreamUTF8.readMultiBytes(input, x & 8, 4);
        }
        if (y == -2) {
            IO.exception(new IOException("Illegal UTF-8: " + x));
        }
        if (y > 65535) {
            throw new AtlasException("Out of range character (must use a surrogate pair)");
        }
        return x;
    }

    private static int readMultiBytes(InputStreamBuffered input, int start, int len) {
        int x = start;
        for (int i = 0; i < len - 1; ++i) {
            int x2 = input.advance();
            if (x2 == -1) {
                throw new AtlasException("Premature end to UTF-8 sequnce at end of input");
            }
            if ((x2 & 0xC0) != 128) {
                throw new AtlasException("Illegal UTF-8 processing character: " + x2);
            }
            x = x << 6 | x2 & 0x3F;
        }
        return x;
    }

    private static void p(int ch) {
        System.out.printf(" %02X", ch);
        if (ch == -1) {
            System.out.println();
        }
    }

    public static String decode(byte[] bytes) {
        try {
            char[] chars = new char[bytes.length];
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            StringBuilder buff = new StringBuilder();
            StreamUTF8 r = new StreamUTF8(in);
            int len = r.read(chars);
            return new String(chars, 0, len);
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }
}

