/*
 * Decompiled with CFR 0.152.
 */
package com.github.egonw.rrdf;

import com.github.egonw.rrdf.StringMatrix;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RJenaHelper {
    public static Model newRdf() throws Exception {
        return ModelFactory.createOntologyModel();
    }

    public static Model loadRdf(String filename, String format) throws Exception {
        OntModel model = ModelFactory.createOntologyModel();
        File file = new File(filename);
        FileInputStream stream = new FileInputStream(file);
        model.read((InputStream)stream, "", format);
        return model;
    }

    public static void saveRdf(Model model, String filename, String format) throws Exception {
        File file = new File(filename);
        FileOutputStream stream = new FileOutputStream(file);
        model.write((OutputStream)stream, format);
        ((OutputStream)stream).close();
    }

    public static String dump(Model model) {
        StringBuffer dump = new StringBuffer();
        StmtIterator statements = model.listStatements();
        while (statements.hasNext()) {
            Statement statement = statements.nextStatement();
            RDFNode object = statement.getObject();
            dump.append(statement.getSubject().getLocalName()).append(' ').append(statement.getPredicate().getLocalName()).append(' ').append(object instanceof Resource ? object.toString() : String.valueOf('\"') + object.toString() + "\"").append('\n');
        }
        return dump.toString();
    }

    public static int tripleCount(Model model) {
        return (int)model.size();
    }

    public static StringMatrix sparql(Model model, String queryString) throws Exception {
        StringMatrix table = null;
        Query query = QueryFactory.create((String)queryString);
        PrefixMapping prefixMap = query.getPrefixMapping();
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        try {
            ResultSet results = qexec.execSelect();
            table = RJenaHelper.convertIntoTable(prefixMap, results);
        }
        finally {
            qexec.close();
        }
        return table;
    }

    public static StringMatrix sparqlRemote(String endpoint, String queryString) throws Exception {
        StringMatrix table = null;
        Query query = QueryFactory.create((String)queryString);
        QueryEngineHTTP qexec = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)endpoint, (Query)query);
        PrefixMapping prefixMap = query.getPrefixMapping();
        try {
            ResultSet results = qexec.execSelect();
            table = RJenaHelper.convertIntoTable(prefixMap, results);
        }
        finally {
            qexec.close();
        }
        return table;
    }

    public static Model construct(Model model, String queryString) throws Exception {
        Model result = null;
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        try {
            result = qexec.execConstruct();
        }
        finally {
            qexec.close();
        }
        return result;
    }

    private static StringMatrix convertIntoTable(PrefixMapping prefixMap, ResultSet results) {
        StringMatrix table = new StringMatrix();
        int rowCount = 0;
        int colCount = 0;
        while (results.hasNext()) {
            colCount = 0;
            ++rowCount;
            QuerySolution soln = results.nextSolution();
            Iterator varNames = soln.varNames();
            while (varNames.hasNext()) {
                String varName = (String)varNames.next();
                table.setColumnName(++colCount, varName);
                RDFNode node = soln.get(varName);
                if (node == null) continue;
                String nodeStr = node.toString();
                if (node.isResource()) {
                    Resource resource = (Resource)node;
                    String[] uriLocalSplit = RJenaHelper.split(prefixMap, resource);
                    if (uriLocalSplit[0] == null) {
                        if (resource.getURI() != null) {
                            table.set(rowCount, colCount, resource.getURI());
                            continue;
                        }
                        table.set(rowCount, colCount, "" + resource.hashCode());
                        continue;
                    }
                    table.set(rowCount, colCount, String.valueOf(uriLocalSplit[0]) + ":" + uriLocalSplit[1]);
                    continue;
                }
                if (nodeStr.endsWith("@en")) {
                    nodeStr = nodeStr.substring(0, nodeStr.lastIndexOf(64));
                }
                table.set(rowCount, colCount, nodeStr);
            }
        }
        return table;
    }

    public static String[] split(PrefixMapping prefixMap, Resource resource) {
        String uri = resource.getURI();
        if (uri == null) {
            return new String[2];
        }
        Map prefixMapMap = prefixMap.getNsPrefixMap();
        Set prefixes = prefixMapMap.keySet();
        String[] split = new String[2];
        for (String key : prefixes) {
            String ns = (String)prefixMapMap.get(key);
            if (!uri.startsWith(ns)) continue;
            split[0] = key;
            split[1] = uri.substring(ns.length());
            return split;
        }
        split[1] = uri;
        return split;
    }

    public static void addObjectProperty(Model model, String subject, String property, String object) throws Exception {
        Resource subjectRes = model.createResource(subject);
        Property propertyRes = model.createProperty(property);
        Resource objectRes = model.createResource(object);
        model.add(subjectRes, propertyRes, (RDFNode)objectRes);
    }

    public static void addDataProperty(Model model, String subject, String property, String value) throws Exception {
        Resource subjectRes = model.createResource(subject);
        Property propertyRes = model.createProperty(property);
        model.add(subjectRes, propertyRes, value);
    }
}

