##' Visualize rrmix Objects
##'
##' S3 methods visualizing results for some objects generated by \code{rrmix} and \code{tune.rrmix}.
##'
##' @name plot
##'
##' @param x an object of class \code{rrmix} or \code{tune.rrmix}.
##' @param pch.L symbol to use for displaying log-likelihood.
##' @param pch.F symbol to use for displaying penalized log-likelihood.
##' @param col.L color code or name for displaying log-likelihood.
##' @param col.F color code or name displaying penalized log-likelihood.
##' @param lty.L line type for displaying log-likelihood.
##' @param lty.F line type for displaying penalized log-likelihood.
##' @param type character indicating the type of plotting.
##' @param metric performance metric to use for finding best `rrmix' model.
##'   `soft.class.err', `hard.class.err', `est.err', and `pred.err' can only be
##'   used when true parameter values are known.
##' @param col the color(s) of the surface facets. Transparent colors are ignored.
##' @param main main title.
##' @param xlab title for the x-axis.
##' @param ylab title for the y-axis.
##' @param swapxy	if TRUE, the parameter axes are swaped (only used in case of
##' two parameters).
##' @param transform.x,transform.y,transform.z functions to transform the parameters
##'   (x and y) and the error measures (z). Ignored if NULL.
##' @param color.palette color palette used in contour plot.
##' @param nlevels number of levels used in contour plot.
##' @param ... Other arguments for future usage.
NULL


hsv_palette <- function(h = 2/3, from = 0.7, to = 0.2, v = 1)
  function(n) grDevices::hsv(h = h, s = seq(from, to, length.out = n), v = v)


##' @rdname plot
##' @export
plot.rrmix <- function(object, pch.L = 1, pch.F = 2, col.L = "red", col.F = "blue",
                       lty.L = 1, lty.F = 1, type = "b", ...)
{
  class(object) <- "plot.rrmix"
  object
}


##' @rdname plot
##' @export
plot.tune.rrmix <- function(object,
                            metric = c("bic", "soft.class.err",
                                       "hard.class.err", "est.err", "pred.err"),
                            col = "blue",
                            main = NULL,
                            xlab = NULL,
                            ylab = NULL,
                            swapxy = FALSE,
                            transform.x = NULL,
                            transform.y = NULL,
                            transform.z = NULL,
                            color.palette = hsv_palette(),
                            nlevels = 20,
                            ...)
{
  class(object) <- "plot.tune.rrmix"
  object
}

