% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/work_with_NULLs.R
\name{count_null_cols}
\alias{count_null_cols}
\title{Count NULLs per row for given column set.}
\usage{
count_null_cols(source, cols, count)
}
\arguments{
\item{source}{incoming rel_op tree or data.frame.}

\item{cols}{character, columns to track}

\item{count}{character, column to write count in.}
}
\value{
rel_op node or data.frame (depending on input).
}
\description{
Build a query that counts the number of nulls in each row.
}
\examples{

# WARNING: example tries to change rquery.rquery_db_executor option to RSQLite and back.
if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  RSQLite::initExtension(my_db)
  old_o <- options(list("rquery.rquery_db_executor" = list(db = my_db)))

  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = c(0.6, 0.5, NA),
                              R2 = c(1.0, 0.9, NA)))
  op_tree <- d \%.>\% count_null_cols(., c("AUC", "R2"), "nnull")
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))

  # ad-hoc mode
  data.frame(AUC=c(1,NA,0.5), R2=c(NA,1,0)) \%.>\%
     op_tree \%.>\%
     print(.)

  # cleanup
  options(old_o)
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{null_replace}}, \code{\link{mark_null_cols}}
}
