% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_ops.R
\name{rq_connection_tests}
\alias{rq_connection_tests}
\title{Try and test database for some option settings.}
\usage{
rq_connection_tests(db, ..., overrides = NULL, use_advice = TRUE)
}
\arguments{
\item{db}{database connection handle.}

\item{...}{force later arguments to bind by name.}

\item{overrides}{named character vector or list, options (just name, not DB qualification) to force}

\item{use_advice}{logical if TRUE incorporate hard-coded advice.}
}
\value{
named list of options
}
\description{
These settings are estimated by experiments.  This is not
the full set of options- but just the ones tested here.
Note: tests are currently run in the default schema.
}
\examples{

if(requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  print(rq_connection_name(my_db))
  print(rq_connection_tests(my_db,
     overrides = c("use_DBI_dbExistsTable" = FALSE)))
  # the following would set options
  # print(options(rq_connection_tests(my_db)))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{rq_connection_advice}}
}
