% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_ops.R
\name{rq_connection_advice}
\alias{rq_connection_advice}
\title{Get advice for a DB connection (beyond tests).}
\usage{
rq_connection_advice(db)
}
\arguments{
\item{db}{database connection handle}
}
\value{
named list of options
}
\description{
These settings are set by the package mainteners based on experience with
specific databases.
}
\examples{

if(requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  print(rq_connection_name(my_db))
  print(rq_connection_advice(my_db))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{rq_connection_tests}}
}
