% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{coef.rq.pen.seq}
\alias{coef.rq.pen.seq}
\title{Returns coefficients of a rq.pen.seq object}
\usage{
\method{coef}{rq.pen.seq}(
  object,
  tau = NULL,
  a = NULL,
  lambda = NULL,
  modelsIndex = NULL,
  lambdaIndex = NULL,
  ...
)
}
\arguments{
\item{object}{rq.pen.seq object}

\item{tau}{Quantile of interest. Default is NULL, which will return all quantiles. Should not be specified if modelsIndex is used.}

\item{a}{Tuning parameter of a. Default is NULL, which returns coefficients for all values of a. Should not be specified if modelsIndex is used.}

\item{lambda}{Tuning parameter of \eqn{\lambda}. Default is NULL, which returns coefficients for all values of \eqn{\lambda}.}

\item{modelsIndex}{Index of the models for which coefficients should be returned. Does not need to be specified if tau or a are specified.}

\item{lambdaIndex}{Index of the lambda values for which coefficients should be returned. Does not need to be specified if lambda is specified.}

\item{...}{Additional parameters.}
}
\value{
A list of a matrix of coefficients for each tau and a combination
}
\description{
Returns coefficients of a rq.pen.seq object
}
\examples{
x <- matrix(runif(800),ncol=8)
y <- 1 + x[,1] + x[,8] + (1+.5*x[,3])*rnorm(100)
m1 <- rq.pen(x,y,penalty="ENet",a=c(0,.5,1),tau=c(.25,.75),lambda=c(.1,.05,.01))
allCoefs <- coef(m1)
targetCoefs <- coef(m1,tau=.25,a=.5,lambda=.1)
idxApproach <- coef(m1,modelsIndex=2)
bothIdxApproach <- coef(m1,modelsIndex=2,lambdaIndex=1)
}
\author{
Ben Sherwood, \email{ben.sherwood@ku.edu}
}
