% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rpf.info}
\alias{rpf.info}
\title{Map an item model, item parameters, and person trait score into a
information vector}
\usage{
rpf.info(ii, ii.p, where, basis = 1)
}
\arguments{
\item{ii}{an item model}

\item{ii.p}{item parameters}

\item{where}{the location in the latent distribution}

\item{basis}{if more than 1 factor, a positive basis vector}
}
\value{
Fisher information
}
\description{
Map an item model, item parameters, and person trait score into a
information vector
}
\examples{
i1 <- rpf.drm()
i1.p <- c(.6,1,.1,.95)
theta <- seq(0,3,.05)
plot(theta, rpf.info(i1, i1.p, t(theta)), type="l")
}
\references{
Dodd, B. G., De Ayala, R. J. & Koch,
W. R. (1995). Computerized adaptive testing with polytomous items.
\emph{Applied psychological measurement 19}(1), 5-22.
}

