% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_descriptions.R
\name{param_thetaH0}
\alias{param_thetaH0}
\title{Parameter Description: Theta H0}
\arguments{
\item{thetaH0}{The null hypothesis value,
default is \code{0} for the normal and the binary case (testing means and rates, respectively),
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
\item \emph{means}: a value \code{!= 0}
(or a value \code{!= 1} for testing the mean ratio) can be specified.
\item \emph{rates}: a value \code{!= 0}
(or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
\item \emph{survival data}: a bound for testing H0: \code{hazard ratio = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for
defining the null hypothesis H0: \code{pi = thetaH0}.}
}
\description{
Parameter Description: Theta H0
}
\keyword{internal}
