% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RosvDownload.R
\name{RosvDownload}
\alias{RosvDownload}
\title{R6 Class for OSV Database Downloads}
\value{
An R6 object to operate with data downloaded from the OSV GCS buckets.
}
\description{
An R6 class to provide a lower-level interface to download from the OSV database GCS buckets.
}
\details{
If no vulnerability IDs are provided, the entire set is downloaded from the ecosystem's all.zip file.
JSON files are downloaded to the R session's temporary folder as dictated by the environment
variable \code{ROSV_CACHE_GLOBAL}. Due to its similarity in parsing process, it simply inherits
the method from the parent class \code{RosvQuery1}.

Any ecosystems listed \href{https://osv-vulnerabilities.storage.googleapis.com/ecosystems.txt}{here} can be downloaded.
}
\examples{
query <- RosvDownload$new(ecosystem = 'CRAN')
query
}
\seealso{
\url{https://google.github.io/osv.dev/data/#data-dumps}
}
\section{Super class}{
\code{\link[rosv:RosvQuery1]{rosv::RosvQuery1}} -> \code{RosvDownload}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{osv_cache_dir}}{Location of cached vulnerability JSON files.}

\item{\code{content}}{Content from downloading the vulnerabilities.}

\item{\code{time_stamp}}{Time stamp associated with run.}

\item{\code{date_stamp_hash}}{Hashed date from time stamp.}

\item{\code{ecosystem}}{The ecosystem used upon creation.}

\item{\code{vuln_ids}}{The vulnerability IDs, if provided.}

\item{\code{request}}{The URLs to request downloaded files.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RosvDownload-new}{\code{RosvDownload$new()}}
\item \href{#method-RosvDownload-download}{\code{RosvDownload$download()}}
\item \href{#method-RosvDownload-run}{\code{RosvDownload$run()}}
\item \href{#method-RosvDownload-print}{\code{RosvDownload$print()}}
\item \href{#method-RosvDownload-clone}{\code{RosvDownload$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rosv" data-topic="RosvQuery1" data-id="parse"><a href='../../rosv/html/RosvQuery1.html#method-RosvQuery1-parse'><code>rosv::RosvQuery1$parse()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvDownload-new"></a>}}
\if{latex}{\out{\hypertarget{method-RosvDownload-new}{}}}
\subsection{Method \code{new()}}{
Set the core request details for subsequent use when called in \code{run()} method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvDownload$new(vuln_ids = NULL, ecosystem)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vuln_ids}}{Character vector of vulnerability IDs.}

\item{\code{ecosystem}}{Ecosystem package lives within (must be set).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvDownload-download"></a>}}
\if{latex}{\out{\hypertarget{method-RosvDownload-download}{}}}
\subsection{Method \code{download()}}{
Download vulnerabilities from provided \code{ecosystem} to disk, the location
is recorded under the \code{osv_cache_dir} field. Will overwrite any existing files
in the cache.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvDownload$download()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvDownload-run"></a>}}
\if{latex}{\out{\hypertarget{method-RosvDownload-run}{}}}
\subsection{Method \code{run()}}{
Load vulnerabilities to the R session. The entire contents of
each vulnerability file will be loaded. Subsequent use of the \code{parse()} method
will shrink the memory footprint as not all contents will be carried across.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvDownload$run()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvDownload-print"></a>}}
\if{latex}{\out{\hypertarget{method-RosvDownload-print}{}}}
\subsection{Method \code{print()}}{
Print basic details of query object to screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvDownload$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Reserved for possible future use.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvDownload-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RosvDownload-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvDownload$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
