% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcid_external_identifiers.R
\name{orcid_external_identifiers}
\alias{orcid_external_identifiers}
\title{Get education information for a person}
\usage{
orcid_external_identifiers(orcid, put_code = NULL,
  format = "application/json", ...)
}
\arguments{
\item{orcid}{(character) Orcid identifier(s), of the form
XXXX-XXXX-XXXX-XXXX. required.}

\item{put_code}{(character/integer) one or more put codes. optional}

\item{format}{(character) Name of the content-type format. One of
"application/vnd.orcid+xml; qs=5", "application/orcid+xml; qs=3",
"application/xml", "application/vnd.orcid+json; qs=4",
"application/orcid+json; qs=2", "application/json"
"application/vnd.citationstyles.csl+json". optional}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
A list of results for each Orcid ID passed in, with each element 
named by the Orcid ID
}
\description{
Get education information for a person
}
\details{
This function is vectorized, so you can pass in many ORCID's, and 
there's an element returned for each ORCID you put in.
}
\examples{
\dontrun{
# all data
res <- orcid_external_identifiers(orcid = "0000-0002-1642-628X")
res$`0000-0002-1642-628X`
names(res$`0000-0002-1642-628X`)
res$`0000-0002-1642-628X`$`external-identifier`

# individual records
orcid_external_identifiers(orcid = "0000-0002-1642-628X", 141736)
}
}
