% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_efi_standard.R
\name{convert_to_efi_standard}
\alias{convert_to_efi_standard}
\title{Convert units and names to CF and Ecological Forecasting Initiative standard}
\usage{
convert_to_efi_standard(df)
}
\arguments{
\item{df}{data frame output by get_ensemble_forecast}
}
\value{
data frame
}
\description{
Output units:
\itemize{
\item air_temperature: K
\item relative_humidity: proportion
\item surface_downwelling_longwave_flux_in_air: W m-2
\item surface_downwelling_shortwave_flux_in_air: W m-2
\item precipitation_flux: kg m-2 s-1
\item wind_speed: m s-1
\item air_pressure: Pa
\item cloud_cover: proportion
}
}
\examples{
file <- system.file("extdata", "test-data.csv", package="ropenmeteo")
df <- readr::read_csv(file, show_col_types = FALSE)
df  |>
  add_longwave() |>
  convert_to_efi_standard()

}
