% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R, R/generic.R, R/star_database.R
\name{snake_case.flat_table}
\alias{snake_case.flat_table}
\alias{snake_case}
\alias{snake_case.star_database}
\title{Transform names according to the snake case style}
\usage{
\method{snake_case}{flat_table}(db)

snake_case(db)

\method{snake_case}{star_database}(db)
}
\arguments{
\item{db}{A \code{flat_table} or \code{star_database} object.}
}
\value{
A \code{flat_table} or \code{star_database} object.
}
\description{
For flat tables, transform attribute and measure names according to the snake
case style. For star databases, transform fact, dimension, measures, and
attribute names according to the snake case style.
}
\details{
This style is suitable if we are going to work with databases.
}
\examples{

db <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()

ft <- flat_table('iris', iris) |>
  snake_case()

}
\seealso{
\code{\link{star_database}}, \code{\link{flat_table}}

Other star database and flat table functions: 
\code{\link{get_attribute_names.flat_table}()},
\code{\link{get_measure_names.flat_table}()},
\code{\link{get_similar_attribute_values.flat_table}()},
\code{\link{get_similar_attribute_values_individually.flat_table}()},
\code{\link{get_unique_attribute_values.flat_table}()},
\code{\link{replace_attribute_values.flat_table}()},
\code{\link{set_attribute_names.flat_table}()},
\code{\link{set_measure_names.flat_table}()}
}
\concept{star database and flat table functions}
