% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{select_measures}
\alias{select_measures}
\alias{select_measures.flat_table}
\title{Select measures of a flat table}
\usage{
select_measures(ft, measures, na_rm)

\method{select_measures}{flat_table}(ft, measures = NULL, na_rm = TRUE)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{measures}{A vector of names.}

\item{na_rm}{A boolean, remove rows from output where all measure values are NA.}
}
\value{
A \code{flat_table} object.
}
\description{
Select only the indicated measures from the flat table.
}
\examples{

ft <- flat_table('iris', iris) |>
  select_measures(measures = c('Sepal.Length', 'Sepal.Width'))

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{add_custom_column}()},
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_empty_values}()},
\code{\link{replace_string}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_attributes}()},
\code{\link{select_instances_by_comparison}()},
\code{\link{select_instances}()},
\code{\link{separate_measures}()},
\code{\link{transform_attribute_format}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_attribute}()},
\code{\link{transform_to_measure}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
