% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rockchalk-package.R
\docType{data}
\name{cheating}
\alias{cheating}
\title{Cheating and Looting in Japanese Electoral Politics}
\format{data.frame: 16623 obs. on 27 variables}
\source{
\url{http://faculty.arts.ubc.ca/bnyblade/publications.html}.
}
\usage{
data(cheating)
}
\description{
Extracted from the "cheating-replication.dta" data file
with permission by the authors, Benjamin Nyblade and Steven
Reed. The Stata data file provided by the authors included
many constructed variables that have been omitted.  Within
R, these can be easily re-contructed by users.
}
\details{
Special thanks to NyBlade and Reed for permission to repackage
this data. Also special thanks to them for creating an especially
transparent variable naming scheme.

The data set includes many columns for variables that can easily
be re-constructed from the columns that are provided here.  While
Stata users might need to manually create 'dummy variables' and
interactions, R users generally do not do that manually.

These variables from the original data set were omitted:

Dummy variables for the year variable: c("yrd1", "yrd2", ...,
"yrd17", "yrd18")

Dummy variables for the ku variable:
c("ku1", "ku2", ..., "ku141", "ku142")

Constructed product variables: c("actualratiosq", "viabsq",
"viab_candcamp_divm", "viab_candothercamp_divm",
"viabsq_candcamp_divm", "viabsq_candothercamp_divm",
"absviab_candcamp", "absviab_candothercamp",
"absviab_candcamp_divm", "absviab_candothercamp_divm",
"viabsq_candcamp", "viabsq_candothercamp", "viab_candcamp",
"viab_candothercamp", "candothercamp_divm", "candcamp_divm",
"candcampminusm", "candothercampminusm", "predratiosq", "absviab")

Mean centered variables: constr2 <- c("viab_candcampminusm",
"viab_candothercampminusm", "viabsq_candothercampminusm",
"viabsq_candcampminusm")

In the end, we are left with these variables:

[1] "ku"
[2] "prefecture"
[3] "dist"
[4] "year"
[5] "yr"
[6] "cdnr"
[7] "jiban"
[8] "cheating"
[9] "looting"
[10] "actualratio"
[11] "viab"
[12] "inc"
[13] "cons"
[14] "ur"
[15] "newcand"
[16] "jwins"
[17] "cons_cwins"
[18] "oth_cwins"
[19] "camp"
[20] "fleader"
[21] "incablast"
[22] "predratio"
[23] "m"
[24] "candcamp"
[25] "candothercamp"
[26] "kunocheat"
[27] "kunoloot"
}
\examples{
require(rockchalk)
data(cheating)

table1model2 <- glm(cheating ~ viab + I(viab^2) + inc + cons + ur
+ newcand + jwins + cons_cwins + oth_cwins, family = binomial(link
= "logit"), data = cheating)

predictOMatic(table1model2)

predictOMatic(table1model2, interval = "confidence")

## The publication used "rare events logistic", which I'm not bothering
## with here because I don't want to invoke additional imported packages.
## But the ordinary logit results are proof of concept.
}
\author{
Paul E. Johnson \email{pauljohn@ku.edu}, on behalf of Benjamin Nyblade and Steven Reed
}
\references{
Benjamin Nyblade and Steven Reed, "Who Cheats? Who
Loots? Political Competition and Corruption in Japan, 1947-1993."
American Journal of Political Science 52(4): 926-41. October 2008.
}
\keyword{datasets}

