% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_to_rmd_template.R
\name{form_to_rmd_template}
\alias{form_to_rmd_template}
\title{Convert a (pre)registration form to an R Markdown template}
\usage{
form_to_rmd_template(
  x,
  file = NULL,
  title = NULL,
  author = NULL,
  date = "`r format(Sys.time(), \\"\%H:\%M:\%S on \%Y-\%m-\%d \%Z (UTC\%z)\\")`",
  output = "html_document",
  yaml = list(title = title, author = author, date = date, output = output),
  includeYAML = TRUE,
  chunkOpts = "echo=FALSE, results='hide'",
  justify = FALSE,
  headingLevel = 1,
  showSpecification = FALSE,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{x}{The (pre)registration form (as produced by a call
to \code{preregr::form_create()} or \code{preregr::import_from_html()}) or
initialized \code{preregr} object (as produced by a call to
\code{preregr::prereg_initialize()} or \code{preregr::import_from_html()}); or, for
the printing method, the R Markdown template produced by a call to
\code{preregr::form_to_rmd_template()}.}

\item{file}{Optionally, a file to save the html to.}

\item{title}{The title to specify in the template's YAML front matter.}

\item{author}{The author to specify in the template's YAML front matter.}

\item{date}{The date to specify in the template's YAML front matter.}

\item{output}{The output format to specify in the template's YAML
front matter.}

\item{yaml}{It is also possible to specify the YAML front matter directly
using this argument. If used, it overrides anything specified in \code{title},
\code{author}, \code{date} and \code{output}.}

\item{includeYAML}{Whether to include the YAML front matter or omit it.}

\item{chunkOpts}{The chunk options to set for the chunks in the template.}

\item{justify}{Whether to use \code{preregr::prereg_specify()} as function for
specifying the (pre)registration content (if \code{FALSE}), or
\code{preregr::prereg_justify()} (if \code{TRUE}).}

\item{headingLevel}{The level of the top-most heading to use (the
title of the (pre)registration form).}

\item{showSpecification}{Whether to show the specification in the Rmd
output. When \code{FALSE}, the \code{preregr} option \code{silent} is set to \code{TRUE} at
the start of the Rmd template; otherwise, it is set to \code{FALSE}.}

\item{preventOverwriting}{Set to \code{FALSE} to override overwrite prevention.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
x, invisibly
}
\description{
This function creates an R Markdown template from a \{preregr\}
(pre)registrations form specification. Pass it the URL to a Google
Sheet holding the (pre)registration form specification (in \{preregr\}
format), see the
"\href{https://r-packages.gitlab.io/preregr/articles/creating_form_from_spreadsheet.html}{Creating a form from a spreadsheet}"
vignette), the path to a file with a spreadsheet holding such a
specification, or a loaded or imported \{preregr\} (pre)registration form.
}
\examples{
preregr::form_create(
  title = "Example form",
  version = "0.1.0"
) |>
  preregr::form_to_rmd_template();
}
