% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rocTree.R
\name{print.rocTree}
\alias{print.rocTree}
\title{Printing an \code{rocTree} object}
\usage{
\method{print}{rocTree}(x, digits = 5, tree = NULL, ...)
}
\arguments{
\item{x}{an \code{rocTree} object.}

\item{digits}{the number of digits of numbers to print.}

\item{tree}{an optional integer specifying the \eqn{n^{th}} tree in the forest to print.
The function prints the contents of an \code{rocForest} object by default,
if a tree is not specified.}

\item{...}{for future development.}
}
\description{
The function prints an \code{rocTree} object. It is a method for the generic function print of class "\code{rocTree}".
}
\examples{
data(simDat)

## Fitting a pruned survival tree
rocTree(Surv(Time, death) ~ z1 + z2, id = id, data = simDat, ensemble = FALSE)

## Fitting a unpruned survival tree
rocTree(Surv(Time, death) ~ z1 + z2, id = id, data = simDat, ensemble = FALSE,
        control = list(numFold = 0))

\dontrun{
## Fitting the ensemble algorithm (default)
rocTree(Surv(Time, death) ~ z1 + z2, id = id, data = simDat, ensemble = TRUE)
}
}
