% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_inf_test.R
\name{beta_inf_correction}
\alias{beta_inf_correction}
\title{Calculates the correction factor for inference under H0 of no outliers}
\usage{
beta_inf_correction(
  robust2sls_object,
  iteration = 1,
  exact = FALSE,
  fp = FALSE
)
}
\arguments{
\item{robust2sls_object}{An object of class \code{"robust2sls"}.}

\item{iteration}{An integer > 0 specifying the iteration step for which
parameters to calculate corrected standard errors.}

\item{exact}{A logical value indicating whether the actually detected share
of outliers (TRUE) or the theoretical share (FALSE) should be used.}

\item{fp}{A logical value whether the fixed point standard error correction
(TRUE) or the exact iteration correction should be computed (FALSE).}
}
\value{
\code{beta_inf_correction} returns the numeric correction factor.
}
\description{
Calculates the correction factor for inference under H0 of no outliers
}
\details{
Argument \code{iteration} specifies which iteration of the robust structural
parameter estimates should be calculated. Iteration \code{1} refers to the
first robust estimate. Iteration \code{0} is not a valid argument since it
is the baseline estimate, which is not robust.

The parameter \code{exact} does not matter much under the null hypothesis of
no outliers since the detected share will converge to the theoretical share.
Under the alternative, this function should not be used.

Argument \code{fp} determines whether the fixed point standard error
correction should be computed. This argument is only respected if the
specified \code{iteration} is one of the iterations after the algorithm
converged.
}
