% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinAUC}
\alias{robinAUC}
\title{robinAUC}
\usage{
robinAUC(
  graph,
  model1,
  model2,
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  verbose = FALSE
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{model1}{The Mean output of the robinRobust function (or the Mean1 
output of the robinCompare function).}

\item{model2}{The MeanRandom output of the robinRobust function (or the 
Mean2 output of the robinCompare function).}

\item{measure}{The stability measure "vi", "nmi", "split.join", 
"adjusted.rand".}

\item{verbose}{flag for verbose output (default as FALSE).}
}
\value{
A list
}
\description{
This function calculates the area under two curves with a spline approach.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
graphRandom <- random(graph=graph)
Proc <- robinRobust(graph=graph, graphRandom=graphRandom, method="louvain",
measure="vi",type="independent")
robinAUC(graph=graph, model1=Proc$Mean, model2=Proc$MeanRandom)
}
