% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_get_species.R
\name{npn_species}
\alias{npn_species}
\alias{npn_species_comm}
\alias{npn_species_id}
\alias{npn_species_itis}
\alias{npn_species_sci}
\alias{npn_species_search}
\alias{npn_species_state}
\title{Get scientific names.}
\usage{
npn_species(...)

npn_species_itis(ids, ...)

npn_species_id(ids, ...)

npn_species_state(state, kingdom = NULL, ...)

npn_species_sci(genus, species, ...)

npn_species_comm(name, ...)

npn_species_search(network = NULL, year = NULL, groups = NULL,
  stationid = NULL, ...)
}
\arguments{
\item{...}{Curl options passed on to \code{\link[httr]{GET}}}

\item{ids}{One or more ITIS taxonomic serial numbers (tsn), or NPN ID numbers.}

\item{state}{Required. A US state, two-letter abbreviation.}

\item{kingdom}{Optional. A taxonomic kingdom.}

\item{genus}{A genus name}

\item{species}{A specific epithet, the second part of a full species name}

\item{name}{A common name}

\item{network}{The primary key of the network for which to filter species.}

\item{year}{Year of obseration}

\item{groups}{One or more primary keys associated with a species type.}

\item{stationid}{Station ID. Use e.g., c(4881, 4882, etc.) if more than one species desired}
}
\value{
data.frame of species and their IDs
}
\description{
Get scientific names.
}
\examples{
\dontrun{
head( npn_species() )
npn_species_itis(ids = 27806)
npn_species_itis(ids = c(27806,36616))
npn_species_id(ids = 3)
npn_species_state(state = "HI")
npn_species_state(state = "HI", kingdom = "Plantae")
npn_species_sci(genus = "Clintonia", species = "borealis")
npn_species_comm(name = "thickleaved wild strawberry")
npn_species_comm(name = c("thickleaved wild strawberry","bluebead"))
npn_species_search(groups = 3, year = 2010)
npn_species_search(groups = c(3,9), year = 2010)

library('httr')
npn_species_itis(ids = 27806, config=verbose())
}
}

