% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcd.R
\name{lcd}
\alias{lcd}
\title{Local Climitalogical Data from NOAA}
\usage{
lcd(station, year, ...)
}
\arguments{
\item{station}{(character) station code, e.g., "02413099999". we will
allow integer/numeric passed here, but station ids can have leading
zeros, so it's a good idea to keep stations as character class. required}

\item{year}{(integer) year, e.g., 2017. required}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
a data.frame with many columns. the first 10 are metadata:
\itemize{
\item station
\item date
\item latitude
\item longitude
\item elevation
\item name
\item report_type
\item source
}

And the rest should be all data columns. The first part of many column
names is the time period, being one of:
\itemize{
\item hourly
\item daily
\item monthly
\item shortduration
}

So the variable you are looking for may not be the first part of the
column name
}
\description{
Local Climitalogical Data from NOAA
}
\note{
See \link{lcd_cache} for managing cached files
}
\examples{
\dontrun{
x = lcd(station = "01338099999", year = 2017)
lcd(station = "01338099999", year = 2015)
lcd(station = "02413099999", year = 2009)
lcd(station = "02413099999", year = 2001)

# pass curl options
lcd(station = "02413099999", year = 2002, verbose = TRUE)
}
}
\references{
Docs:
https://www.ncei.noaa.gov/data/local-climatological-data/doc/LCD_documentation.pdf
Data comes from:
https://www.ncei.noaa.gov/data/local-climatological-data/access
}
