% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/league.table.absolute.user_function.R
\name{league_table_absolute_user}
\alias{league_table_absolute_user}
\title{League table for relative and absolute effects (user defined)}
\usage{
league_table_absolute_user(
  data,
  measure,
  base_risk,
  drug_names,
  show = NULL,
  save_xls
)
}
\arguments{
\item{data}{A data-frame with the summary effects of comparisons with the
reference intervention of the network, known as basic parameters. The
data-frame has \code{T} rows (\code{T} is the number of interventions in
the network) and four columns that contain the point estimate, the lower
and upper bound of the 95\% (confidence or credible) interval of the
corresponding basic parameters, and a ranking measure to indicate the order
of the interventions in the hierarchy from the best to the worst with
possible choices a non-zero positive integer for the rank, the SUCRA value
(Salanti et al., 2011) or p-score value (Ruecker and Schwarzer, 2015).
The first row of the data-frame refers to the selected reference
intervention and should include (1) the null value three times at the
investigated effect measure (i.e. 1 for odds ratio and relative risk, and 0
for risk difference), and (2) the value of the ranking measure.}

\item{measure}{Character string indicating the effect measure of \code{data}.
For a binary outcome, the following can be considered: \code{"OR"},
\code{"RR"} or \code{"RD"} for the odds ratio, relative risk, and risk
difference, respectively.}

\item{base_risk}{A number in the interval (0, 1) that indicates the baseline
risk for the selected reference intervention.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data}.
The first intervention should be the selected reference intervention.}

\item{show}{A vector of at least three character strings that refer to the
names of the interventions \emph{exactly} as defined in \code{drug_names}.
Then, the league table will be created for these interventions only.
If \code{show} is not defined, the league table will present all
interventions as defined in \code{drug_names}.}

\item{save_xls}{Logical to indicate whether to export the tabulated results
to an 'xlsx' file (via the \code{\link[writexl:write_xlsx]{write_xlsx}}
function of the R-package
\href{https://CRAN.R-project.org/package=writexl}{writexl}) to the working
directory of the user. The default is \code{FALSE} (do not export).}
}
\value{
A league table showing the estimate and 95\% confidence interval of
  the odds ratio (upper off-diagonals), risk difference per 1000
  participants (lower off-diagonals), and absolute risks per 1000
  participants (main diagonal).
}
\description{
In line with \code{\link{league_table_absolute}}, provides a league table
  of the estimated odds ratio, and risk difference per 1000 participants for
  all possible comparisons of interventions in the network.
  The main diagonal of the table presents the absolute risk for each
  intervention in the network. \code{league_table_absolute_user} requires
  users to input the summary effect and 95\% credible or confidence interval
  of the basic parameters in the reported effect measure. This function
  should be used when the user has access to the results of a published
  systematic review rather than the raw trial-level data. In the latter case,
  the user should consider the function \code{\link{league_table_absolute}}.
  \code{league_table_absolute_user} is applied for one binary outcome only.
}
\details{
When the published results are reported in the relative risk scale
  (i.e., \code{measure = "RR"}), the function calculates odds ratios and risk
  differences (point estimate and 95\% confidence interval) for all possible
  pairwise comparisons in the network based on the obtained absolute risks
  and the selected baseline risk. Likewise, when the published results are in
  the odds ratio or risk difference scale (i.e., \code{measure = "OR"} or
  \code{measure = "RD"}, respectively), the function calculates risk
  differences or odds ratios (point estimate and 95\% confidence interval),
  respectively, for all possible pairwise comparisons in the network based on
  the obtained absolute risks and the selected baseline risk.

  The rows and columns of the league table display the names of the
  interventions  sorted by decreasing order from the best to the worst
  based on the ranking measure in the fourth column of the argument
  \code{data}. The upper off-diagonals contain the estimate and 95\%
  confidence interval of the odds ratio, the lower off-diagonals contain the
  estimate and 95\% confidence interval of the risk difference (per 1000
  participants), and the main diagonal comprises the absolute risks and their
  95\% confidence interval (per 1000 participants) of the corresponding
  non-reference interventions. The reference intervention of the network
  (which the baseline risk has been selected for) is indicated in the main
  diagonal with a black, thick frame.

  Comparisons between interventions should be read from left to right.
  Results that indicate strong evidence in favour of the row-defining
  intervention (i.e. the respective 95\% confidence interval does not include
  the null value) are indicated in bold.

  Furthermore, \code{league_table_absolute_user} exports
  \code{table_relative_absolute_effect}, a table with the relative and
  absolute effects of the basic parameters, as an 'xlsx' file (via the
  \code{\link[writexl:write_xlsx]{write_xlsx}} function) to the working
  directory of the user.

  To obtain unique absolute risks for each intervention, we have considered
  the transitive risks framework, namely, an intervention has the same
  absolute risk regardless of the comparator intervention(s) in a trial
  (Spineli et al., 2017).

  \code{league_table_absolute_user} can be used only for a network of
  interventions. In the case of two interventions, the execution of the
  function will be stopped and an error message will be printed in the R
  console.
}
\references{
Ruecker G, Schwarzer G. Ranking treatments in frequentist network
meta-analysis works without resampling methods.
\emph{BMC Med Res Methodol} 2015;\bold{15}:58.
doi: 10.1186/s12874-015-0060-8

Salanti G, Ades AE, Ioannidis JP. Graphical methods and numerical summaries
for presenting results from multiple-treatment meta-analysis: an overview and
tutorial. \emph{J Clin Epidemiol} 2011;\bold{64}(2):163--71.
doi: 10.1016/j.jclinepi.2010.03.016

Spineli LM, Brignardello-Petersen R, Heen AF, Achille F, Brandt L,
Guyatt GH, et al. Obtaining absolute effect estimates to facilitate shared
decision making in the context of multiple-treatment comparisons.
Abstracts of the Global Evidence Summit, Cape Town, South Africa.
\emph{Cochrane Database of Systematic Reviews} 2017;\bold{9}(Suppl 1):1891.
}
\seealso{
\code{\link{league_table_absolute}},
  \code{\link[writexl:write_xlsx]{write_xlsx}}
}
\author{
{Loukia M. Spineli}
}
