% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_tables.R
\name{get_current_exchangerate_table}
\alias{get_current_exchangerate_table}
\title{Retrieves the current exchange rate table.}
\usage{
get_current_exchangerate_table(table)
}
\arguments{
\item{table}{specifies which table should be fetched.}
}
\value{
nbp_api_response object containing the current
exchange rate table.
}
\description{
Retrieves the current exchange rate table.
}
\examples{

\donttest{
  tryCatch({
      ## Retrieve the current A exchange rate table
      response <- get_current_exchangerate_table("A")
      ## Retrieve the content
      response$content
    },
    error = function(e) message(e)
  )
}

}
\seealso{
\url{https://api.nbp.pl/#kursyWalut}

Other tables: 
\code{\link{get_exchangerate_table_from}()},
\code{\link{get_exchangerate_tables_from_interval}()},
\code{\link{get_last_n_exchangerate_tables}()},
\code{\link{get_todays_exchangerate_table}()}
}
\concept{tables}
