% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_predict_nested_sets.R
\name{rmw_predict_nested_sets}
\alias{rmw_predict_nested_sets}
\title{Function to make predictions from a random forest models using a nested 
tibble.}
\usage{
rmw_predict_nested_sets(
  df_nest,
  se = FALSE,
  n_cores = NULL,
  keep_vectors = FALSE,
  model_errors = FALSE,
  as_long = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{df_nest}{Nested tibble created by \code{\link{rmw_model_nested_sets}}.}

\item{se}{Should the standard error of the predictions be calculated?}

\item{n_cores}{Number of CPU cores to use for the model calculations.}

\item{keep_vectors}{Should the prediction vectors be kept in the return? This
is usually not needed because these vectors have been added to the 
\code{observations} variable.}

\item{model_errors}{Should model error statistics between the observed and 
predicted values be calculated and returned?}

\item{as_long}{For when \code{model_errors} is \code{TRUE}, should the model 
error unit be returned in "long format"?}

\item{verbose}{Should the function give messages?}
}
\value{
Nested tibble.
}
\description{
Function to make predictions from a random forest models using a nested 
tibble.
}
\seealso{
\code{\link{rmw_nest_for_modelling}}, 
\code{\link{rmw_model_nested_sets}}, \code{\link{rmw_predict}}, 
\code{\link{rmw_calculate_model_errors}}
}
\author{
Stuart K. Grange
}
