/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.loader.fileLoader;

import dmLab.array.Array;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.fileLoader.FileType;
import dmLab.array.loader.fileLoader.NullLabels;
import java.io.File;

public abstract class FileLoader {
    protected int eventsNumber;
    protected int attributesNumber;
    protected int ignoredAttributesNumber;
    public boolean trimComments = true;
    public char separator = (char)44;
    protected NullLabels nullLabels;
    private String defaultNullLabel = "?";
    protected boolean[] ignoredAttributeMask;
    protected Array myArray;
    protected String commentChar = "#";
    protected int fileType = -1;

    public FileLoader() {
        this.init();
    }

    public final void init() {
        this.nullLabels = new NullLabels(5);
        this.ignoredAttributeMask = null;
        this.eventsNumber = 0;
        this.attributesNumber = 0;
        this.ignoredAttributesNumber = 0;
        this.myInit();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean loadFile(Array array, File file) {
        boolean bl;
        FileLoader fileLoader;
        String string = DiscFunctions.getFileExtension(file.getName());
        if (FileType.toType(string) != this.fileType) {
            System.err.println("Input file is not " + FileType.toTypeStr(this.fileType) + " type. File: " + file.toString());
            return false;
        }
        if (!this.readHeaderFile(file)) {
            return false;
        }
        System.out.println("Loading data: '" + this.getDataFile(file).getName() + "'...");
        this.myArray = fileLoader;
        if (!this.parseInputFile(file)) {
            System.err.println("Error Parsing file. File: " + this.getDataFile(file).toString());
            return false;
        }
        fileLoader = this;
        System.out.println("attributes: " + fileLoader.attributesNumber + " events: " + fileLoader.eventsNumber);
        if (fileLoader.attributesNumber == 0) {
            System.err.println("Input data does not contain attributes.");
            bl = false;
        } else if (fileLoader.eventsNumber == 0) {
            System.err.println("Input data does not contain events.");
            bl = false;
        } else {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        this.myArray.init(this.attributesNumber, this.eventsNumber);
        this.ignoredAttributeMask = new boolean[this.attributesNumber + this.ignoredAttributesNumber];
        if (!this.readInputFile(file)) {
            void var2_2;
            System.err.println("Error reading file. File: " + var2_2.toString());
            return false;
        }
        System.out.println("Data loaded.");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected final String trimComments(String inputLine) {
        void var1_1;
        if (!this.trimComments) {
            return inputLine;
        }
        if (inputLine == null) {
            return null;
        }
        if (inputLine.indexOf(this.commentChar) == -1) {
            return inputLine.trim();
        }
        return inputLine.substring(0, var1_1.indexOf(this.commentChar)).trim();
    }

    protected final boolean loadEvent(String inputLine, int row) {
        int column = 0;
        String[] list = DiscFunctions.tokenizeString(inputLine, new char[]{this.separator}, false);
        if (list.length != this.attributesNumber + this.ignoredAttributesNumber) {
            System.err.println("Number of values does not equal to defined attributes number. Event: " + row);
            return false;
        }
        int i = 0;
        while (i < this.ignoredAttributeMask.length) {
            if (!this.ignoredAttributeMask[i]) {
                String value = list[i];
                if (this.nullLabels.containsIgnoreCase(value)) {
                    value = this.defaultNullLabel;
                }
                if (value.length() != 0) {
                    if (!this.myArray.writeValueStr(column, row, value)) {
                        System.err.println("Error loading value. Attribute: " + this.myArray.attributes[column].name + " (#" + i + ") value: " + value);
                        return false;
                    }
                    ++column;
                } else {
                    System.err.println("Empty Value! Attribute: " + this.myArray.attributes[column].name + " (#" + i + ")");
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected abstract boolean readHeaderFile(File var1);

    protected abstract boolean parseInputFile(File var1);

    protected abstract boolean readInputFile(File var1);

    protected abstract boolean myInit();

    protected abstract File getDataFile(File var1);
}

