/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;

public abstract class PotentialClassIgnorer
extends Filter
implements OptionHandler {
    private static final long serialVersionUID = 8625371119276845454L;
    protected boolean m_IgnoreClass = false;
    protected int m_ClassIndex = -1;

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tUnsets the class index temporarily before the filter is\n\tapplied to the data.\n\t(default: no)", "unset-class-temporarily", 1, "-unset-class-temporarily"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setIgnoreClass(Utils.getFlag("unset-class-temporarily", options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getIgnoreClass()) {
            result.add("-unset-class-temporarily");
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        boolean result = super.setInputFormat(instanceInfo);
        if (this.m_IgnoreClass) {
            this.m_ClassIndex = this.inputFormatPeek().classIndex();
            this.inputFormatPeek().setClassIndex(-1);
        }
        return result;
    }

    @Override
    public Instances getOutputFormat() {
        if (this.m_IgnoreClass) {
            this.outputFormatPeek().setClassIndex(this.m_ClassIndex);
        }
        return super.getOutputFormat();
    }

    public String ignoreClassTipText() {
        return "The class index will be unset temporarily before the filter is applied.";
    }

    public void setIgnoreClass(boolean newIgnoreClass) {
        this.m_IgnoreClass = newIgnoreClass;
    }

    public boolean getIgnoreClass() {
        return this.m_IgnoreClass;
    }
}

