% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{plotClusterFactors}
\alias{plotClusterFactors}
\title{Plot heatmap of cluster/factor correspondence}
\usage{
plotClusterFactors(
  object,
  use.aligned = FALSE,
  Rowv = NA,
  Colv = "Rowv",
  col = NULL,
  return.data = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{liger} object.}

\item{use.aligned}{Use quantile normalized factor loadings to generate matrix (default FALSE).}

\item{Rowv}{Determines if and how the row dendrogram should be computed and reordered. Either a
dendrogram or a vector of values used to reorder the row dendrogram or NA to suppress any row
dendrogram (and reordering) (default NA for no dendrogram).}

\item{Colv}{Determines if and how the column dendrogram should be reordered. Has the same options
as the Rowv argument (default 'Rowv' to match Rowv).}

\item{col}{Color map to use (defaults to red and black)}

\item{return.data}{Return matrix of total factor loadings for each cluster (default FALSE).}

\item{...}{Additional parameters to pass on to heatmap()}
}
\value{
If requested, matrix of size num_cluster x num_factor
}
\description{
Generates matrix of cluster/factor correspondence, using sum of row-normalized factor loadings
for every cell in each cluster. Plots heatmap of matrix, with red representing high total
loadings for a factor, black low. Optionally can also include dendrograms and sorting for
factors and clusters.
}
\examples{
\dontrun{
# ligerex (liger object), factorization complete input
# plot expression for CD4 and return plots
loading.matrix <- plotClusterFactors(ligerex, return.data = T)
}
}
