# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Approximation Algorithms
#' @name Approximation-Algorithms
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @param numNodes, the number of nodes in the graph
#' @return a List with 1) the clique size, and 2) the members of the clique
NULL

#' @rdname Approximation-Algorithms
#' @description `GrossoLocatelliPullanMcRunner` runs the Grosso, Locatelli, and Pullan for solving the maximum clique problem
GrossoLocatelliPullanMcRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_GrossoLocatelliPullanMcRunner`, arcSources, arcTargets, numNodes)
}

#' Graph Input Specifications
#' @name Input-Information
#' @description Due to how LEMON operates, and to make the interfaces similar to the actual program,
#' graphs in rlemon use the following 2 vectors:
#' arcSources, and arcTargets
#' to acquire information about how the graph is structured
#' each edge in a graph will consist of a (node id, node id) pair, which is represented
#' by the ith entry in both arcSources and arcTargets.
#' The nodes are 0-indexed, and must be sequential.
#' numNodes must be equal to the number of nodes in the graph, as otherwise there
#' are potentials to error out.
#' As an example, the cycle graph on three vertices would have the following input:
#' arcSources <- c(0,1,2)
#' arcTargets <- c(1,2,0)
#' numNodes <- 3
#' Here, the edges are (0,1), (1,2), (2,0)
NULL

#' Connectivity Algorithms - Boolean Return
#' @name Connectivity-Algorithms-1
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @param numNodes, the number of nodes in the graph
#' @return a boolean, stating if a graph has some property
NULL

#' Connectivity Algorithms - Integer Return
#' @name Connectivity-Algorithms-2
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @param numNodes, the number of nodes in the graph
#' @return an integer, counting some property of a graph
NULL

#' Connectivity Algorithms - List Return
#' @name Connectivity-Algorithms-3
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @param numNodes, the number of nodes in the graph
#' @return a List, returning some set of nodes or edges in a graph
NULL

#' @rdname Connectivity-Algorithms-3
#' @return `getBipartitePartitionsRunner` returns an R List containing (1) A boolean stating if the graph is bipartite, and (2) an std::vector of length numNodes, containing the partition for each node
getBipartitePartitionsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_getBipartitePartitionsRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-3
#' @return `getAndCheckTopologicalSortRunner` returns an R List containing (1) A boolean stating if the graph is a dag, and (2) a vector of length numNodes, containing the index of vertex i in the ordering at location i
getAndCheckTopologicalSortRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_getAndCheckTopologicalSortRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-3
#' @return `getTopologicalSortRunner` returns a vector of length numNodes, containing the index of vertex i in the ordering at location i.
getTopologicalSortRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_getTopologicalSortRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsConnected` returns if a graph is connected or not
#' @examples
#' data(small_graph_example)
#' start <- small_graph_example$startnodes
#' end <- small_graph_example$endnodes
#' numnodes <- length(unique(c(start, end)))
#' IsConnected(start, end, numnodes)
IsConnectedRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsConnectedRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsAcyclic` returns if a graph is acyclic or not
IsAcyclicRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsAcyclicRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsTree` returns if a graph is a tree or not
IsTreeRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsTreeRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsBipartite` returns if a graph is bipartite or not
IsBipartiteRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsBipartiteRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsStronglyConnected` returns if a graph is strongly connected or not
IsStronglyConnectedRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsStronglyConnectedRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsDAG` returns if a graph is a DAG or not
IsDAGRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsDAGRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsBiNodeConnected` returns if a graph is bi-node connected or not
IsBiNodeConnectedRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsBiNodeConnectedRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsBiEdgeConnected` returns if a graph is bi-edge connected or not
IsBiEdgeConnectedRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsBiEdgeConnectedRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsLoopFree` returns if a graph is loop-free or not
IsLoopFreeRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsLoopFreeRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsParallelFree` returns if a graph is parallel-free or not
IsParallelFreeRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsParallelFreeRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsSimpleGraph` returns if a graph is simple or not
IsSimpleGraphRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsSimpleGraphRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-1
#' @description `IsEulerian` returns if a graph is Eulerian or not
IsEulerianRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_IsEulerianRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-2
#' @description `CountBiEdgeConnectedComponents` returns how many Bi-Edge Connected Components a graph has.
CountBiEdgeConnectedComponentsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_CountBiEdgeConnectedComponentsRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-2
#' @description `CountConnectedComponents` returns how many Connected Components a graph has.
CountConnectedComponentsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_CountConnectedComponentsRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-2
#' @description `CountBiNodeConnectedComponents` returns how many Bi-Node Connected Components a graph has.
CountBiNodeConnectedComponentsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_CountBiNodeConnectedComponentsRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-2
#' @description `CountStronglyConnectedComponents` returns how many Strongly Connected Components a graph has.
CountStronglyConnectedComponentsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_CountStronglyConnectedComponentsRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-3
#' @description `FindStronglyConnectedComponents` returns a vector containing the component number of each node
FindStronglyConnectedComponentsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_FindStronglyConnectedComponentsRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-3
#' @description `FindStronglyConnectedCutArcs` returns an R List containing 1) A list of cut arc sources, and 2) A list of cut arc destinations
FindStronglyConnectedCutArcsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_FindStronglyConnectedCutArcsRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-3
#' @description `FindBiEdgeConnectedCutEdges` returns an R List containing 1) A list of cut edge sources, and 2) A list of cut edge destinations
FindBiEdgeConnectedCutEdgesRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_FindBiEdgeConnectedCutEdgesRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-3
#' @description `FindBiNodeConnectedCutComponents` returns a vector containing the component number of each cut arc.
FindBiNodeConnectedComponentsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_FindBiNodeConnectedComponentsRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-3
#' @description `FindBiNodeConnectedCutNodes` returns a vector containing the cut nodes
FindBiNodeConnectedCutNodesRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_FindBiNodeConnectedCutNodesRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-3
#' @description `FindConnectedComponents` returns a vector containing the component number of each node
FindConnectedComponentsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_FindConnectedComponentsRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Connectivity-Algorithms-3
#' @description `FindBiEdgeConnectedComponents` returns a vector containing the component number of each node
FindBiEdgeConnectedComponentsRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_FindBiEdgeConnectedComponentsRunner`, arcSources, arcTargets, numNodes)
}

#' Compatible Graph Converter
#' @name Graph-Converter
#' @param nodesList, a vector of all the nodes in the graph
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @return A list containing four entries: 1) rlemon compatible nodes, 2) arcSources which match the converted nodes 3) arcTargets which match the converted nodes, 4) a mapping of the original and converted nodes
NULL

#' @rdname Graph-Converter
#' @description 'GraphCompatabilityConverter' returns a compatible version of the graph which can be used with the rest of rlemon's interfaces. rlemon's interface requires all node inputs to be 0-indexed.
GraphCompatabilityConverter <- function(nodesList, arcSources, arcTargets) {
    .Call(`_rlemon_GraphCompatabilityConverter`, nodesList, arcSources, arcTargets)
}

#' Graph Search Algorithms
#' @name Graph-Search-Algorithms-1
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @param numNodes, the number of nodes in the graph
#' @param startNode, the start node of the path
#' @param endNode, the end node of the path
#' @return A list containing three entries: 1) the predecessor of each vertex in its shortest path, 2) the distances from each node to the startNode , 3) a list containing if a node was reached or not
NULL

#' Graph Search Algorithms
#' @name Graph-Search-Algorithms-2
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @param arcCapacities, a vector corresponding to the distances of a graph's edges
#' @param numNodes, the number of nodes in the graph
#' @param startNode, the start node of the path
#' @return A list containing two entries: 1) the cardinality of each node , 2) a list containing if a node was reached or not
NULL

#' @rdname Graph-Search-Algorithms-1
#' @description `BfsRunner` calculates the shortest path using Breath-First-Search
BfsRunner <- function(arcSources, arcTargets, numNodes, startNode = -1L, endNode = -1L) {
    .Call(`_rlemon_BfsRunner`, arcSources, arcTargets, numNodes, startNode, endNode)
}

#' @rdname Graph-Search-Algorithms-1
#' @description `DfsRunner` calculates the shortest path using Depth-First-Search
DfsRunner <- function(arcSources, arcTargets, numNodes, startNode = -1L, endNode = -1L) {
    .Call(`_rlemon_DfsRunner`, arcSources, arcTargets, numNodes, startNode, endNode)
}

#' @rdname Graph-Search-Algorithms-2
#' @description `MaxCardinalitySearchRunner` runs the Maximum Cardinality Search Algorithm
MaxCardinalitySearchRunner <- function(arcSources, arcTargets, arcCapacities, numNodes, startNode = -1L) {
    .Call(`_rlemon_MaxCardinalitySearchRunner`, arcSources, arcTargets, arcCapacities, numNodes, startNode)
}

#' Maximum Flow Algorithms - Network Circulation
#' @name Maximum-Flow-Algorithms-2
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcLowerBound Vector corresponding to the lower-bound capacities of nodes of a graph's edges
#' @param arcUpperBound Vector corresponding to the upper-bound capacities of nodes of a graph's edges
#' @param nodeSupplies Vector corresponding to the supplies of each node of the graph.
#' @param numNodes The number of nodes in the graph
#' @return A list containing two entries: 1) A list corresponding to the flows of arcs in the graph, and 2) A list of the graph's barrier nodes.
NULL

#' Maximum Flow Algorithms
#' @name Maximum-Flow-Algorithms-1
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcDistances Vector corresponding to the capacities of nodes of a graph's edges
#' @param sourceNode The source node
#' @param destinationNode The destination node
#' @param numNodes The number of nodes in the graph
#' @return A list containing three entries: 1) A list corresponding to the flows of arcs in the graph, 2) A list of cut-values of the graph's nodes, and 3) the total cost of the flows in the graph, i.e. the maxflow value.
NULL

#' @rdname Maximum-Flow-Algorithms-2
#' @description `CirculationRunner` runs the Circulation Algorithm to calculate the maximum flow.
CirculationRunner <- function(arcSources, arcTargets, arcLowerBound, arcUpperBound, nodeSupplies, numNodes) {
    .Call(`_rlemon_CirculationRunner`, arcSources, arcTargets, arcLowerBound, arcUpperBound, nodeSupplies, numNodes)
}

#' @rdname Maximum-Flow-Algorithms-1
#' @description `PreflowRunner` runs the Preflow Algorithm to calculate the maximum flow.
PreflowRunner <- function(arcSources, arcTargets, arcDistances, sourceNode, destinationNode, numNodes) {
    .Call(`_rlemon_PreflowRunner`, arcSources, arcTargets, arcDistances, sourceNode, destinationNode, numNodes)
}

#' @rdname Maximum-Flow-Algorithms-1
#' @description `EdmondsKarpRunner` runs the EdmondsKarp Algorithm to calculate the maximum flow.
EdmondsKarpRunner <- function(arcSources, arcTargets, arcDistances, sourceNode, destinationNode, numNodes) {
    .Call(`_rlemon_EdmondsKarpRunner`, arcSources, arcTargets, arcDistances, sourceNode, destinationNode, numNodes)
}

#' Maximum Matching Algorithms
#' @name Maximum-Matching-Algorithms
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcWeights Vector corresponding to the weights of a graph's edges
#' @param numNodes The number of nodes in the graph
#' @return A list containing two entries: 1) The matching value, 2) The edges of the final graph, in a List of List of (node, node) pairs
NULL

#' @rdname Maximum-Matching-Algorithms
#' @description `MaximumWeightPerfectMatchingRunner` solves the Maximum-Weight Perfect Matching Problem
MaximumWeightPerfectMatchingRunner <- function(arcSources, arcTargets, arcWeights, numNodes) {
    .Call(`_rlemon_MaximumWeightPerfectMatchingRunner`, arcSources, arcTargets, arcWeights, numNodes)
}

#' @rdname Maximum-Matching-Algorithms
#' @description `MaximumWeightFractionalPerfectMatchingRunner` solves the Maximum-Weight Fractional Perfect Matching Problem
MaximumWeightFractionalPerfectMatchingRunner <- function(arcSources, arcTargets, arcWeights, numNodes) {
    .Call(`_rlemon_MaximumWeightFractionalPerfectMatchingRunner`, arcSources, arcTargets, arcWeights, numNodes)
}

#' @rdname Maximum-Matching-Algorithms
#' @description `MaximumWeightFractionalMatchingRunner` solves the Maximum-Weight Fractional Matching Problem
MaximumWeightFractionalMatchingRunner <- function(arcSources, arcTargets, arcWeights, numNodes) {
    .Call(`_rlemon_MaximumWeightFractionalMatchingRunner`, arcSources, arcTargets, arcWeights, numNodes)
}

#' @rdname Maximum-Matching-Algorithms
#' @description `MaximumWeightMatchingRunner` solves the Maximum-Weight Matching Problem
MaximumWeightMatchingRunner <- function(arcSources, arcTargets, arcWeights, numNodes) {
    .Call(`_rlemon_MaximumWeightMatchingRunner`, arcSources, arcTargets, arcWeights, numNodes)
}

#' @rdname Maximum-Matching-Algorithms
#' @description `MaximumCardinalityMatchingRunner` solves the Maximum Cardinality Matching Problem
MaximumCardinalityMatchingRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_MaximumCardinalityMatchingRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Maximum-Matching-Algorithms
#' @description `MaximumCardinalityFractionalMatchingRunner` solves the Maximum-Cardinality Fractional Matching Problem
MaximumCardinalityFractionalMatchingRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_MaximumCardinalityFractionalMatchingRunner`, arcSources, arcTargets, numNodes)
}

#' Minimum Cost Flow Algorithms
#' @name Minimum-Cost-Flow-Algorithms
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @param arcCapacities, a vector corresponding to the capacities of nodes of a graph's edges
#' @param arcCosts, a vector corresponding to the capacities of nodes of a graph's edges
#' @param nodeSupplies, a vector corresponding to the supplies of each node
#' @param numNodes, the number of nodes in the graph
#' @return A list containing three entries: 1) A list corresponding to the flows of arcs in the graph, 2) A list of potentials of the graph's nodes, and 3) the total cost of the flows in the graph, i.e. the mincostflow value
NULL

#' @rdname Minimum-Cost-Flow-Algorithms
#' @description `CycleCancellingRunner` runs the Cycle-Cancelling Algorithm to calculate the minimum cost flow.
CycleCancellingRunner <- function(arcSources, arcTargets, arcCapacities, arcCosts, nodeSupplies, numNodes) {
    .Call(`_rlemon_CycleCancellingRunner`, arcSources, arcTargets, arcCapacities, arcCosts, nodeSupplies, numNodes)
}

#' @rdname Minimum-Cost-Flow-Algorithms
#' @description `CapacityScalingRunner` runs the Capacity-Scaling Algorithm to calculate the minimum cost flow.
CapacityScalingRunner <- function(arcSources, arcTargets, arcCapacities, arcCosts, nodeSupplies, numNodes) {
    .Call(`_rlemon_CapacityScalingRunner`, arcSources, arcTargets, arcCapacities, arcCosts, nodeSupplies, numNodes)
}

#' @rdname Minimum-Cost-Flow-Algorithms
#' @description `CostScalingRunner` runs the Cost-Scaling Algorithm to calculate the minimum cost flow.
CostScalingRunner <- function(arcSources, arcTargets, arcCapacities, arcCosts, nodeSupplies, numNodes) {
    .Call(`_rlemon_CostScalingRunner`, arcSources, arcTargets, arcCapacities, arcCosts, nodeSupplies, numNodes)
}

#' @rdname Minimum-Cost-Flow-Algorithms
#' @description `NetworkSimplexRunner` runs the Network-Simplex Algorithm to calculate the minimum cost flow.
NetworkSimplexRunner <- function(arcSources, arcTargets, arcCapacities, arcCosts, nodeSupplies, numNodes) {
    .Call(`_rlemon_NetworkSimplexRunner`, arcSources, arcTargets, arcCapacities, arcCosts, nodeSupplies, numNodes)
}

#' Minimum Cut Algorithms - Gomory Hu Tree
#' @name Minimum-Cut-Algorithms-2
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcWeights Vector corresponding to the weights of a graph's edges
#' @param numNodes The number of nodes in the graph
#' @return Calculates a Gomory-Hu Tree and returns a list containing three entries: 1) A list of predecessor nodes of each node in the graph, and 2) A list of weights of the predecessor edge of each node, and 3) A list of distances from the root node to each node.
NULL

#' Minimum Cut Algorithms
#' @name Minimum-Cut-Algorithms-1
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcWeights Vector corresponding to the weights of a graph's edges
#' @param numNodes The number of nodes in the graph
#' @return A list containing three entries: 1) The value of the minimum cut in the graph, and 2) A list of nodes in the first partition, and 3) A list of nodes in the second partition.
NULL

#' @rdname Minimum-Cut-Algorithms-1
#' @description `NagamochiIbarakiRunner` runs the Nagamochi-Ibaraki Algorithm to calculate the minimum cut.
NagamochiIbarakiRunner <- function(arcSources, arcTargets, arcWeights, numNodes) {
    .Call(`_rlemon_NagamochiIbarakiRunner`, arcSources, arcTargets, arcWeights, numNodes)
}

#' @rdname Minimum-Cut-Algorithms-1
#' @description `HaoOrlinRunner` runs the Hao-Orlin Algorithm to calculate the minimum cut.
HaoOrlinRunner <- function(arcSources, arcTargets, arcWeights, numNodes) {
    .Call(`_rlemon_HaoOrlinRunner`, arcSources, arcTargets, arcWeights, numNodes)
}

#' @rdname Minimum-Cut-Algorithms-2
#' @description `GomoryHuTreeRunner` runs the Gomory-Hu Algorithm to calculate a rooted Gomory Hu Tree.
GomoryHuTreeRunner <- function(arcSources, arcTargets, arcWeights, numNodes) {
    .Call(`_rlemon_GomoryHuTreeRunner`, arcSources, arcTargets, arcWeights, numNodes)
}

#' Minimum Mean-Cycle Algorithms
#' @name Maximum-Mean-Cycle-Algorithms
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcDistances Vector corresponding to the distances of a graph's edges
#' @param numNodes The number of nodes in the graph
#' @return A list containing two entries: 1) A vector containing the costs of each edge in the MMC, and 2) the nodes in the MMC.
NULL

#' @rdname Maximum-Mean-Cycle-Algorithms
#' @description `HowardMmcRunner` runs Howard's policy iteration algorithm to find a directed cycle of minimum mean cost.
HowardMmcRunner <- function(arcSources, arcTargets, arcDistances, numNodes) {
    .Call(`_rlemon_HowardMmcRunner`, arcSources, arcTargets, arcDistances, numNodes)
}

#' @rdname Maximum-Mean-Cycle-Algorithms
#' @description `KarpMmcRunner` runs Karp's algorithm to find a directed cycle of minimum mean cost .
KarpMmcRunner <- function(arcSources, arcTargets, arcDistances, numNodes) {
    .Call(`_rlemon_KarpMmcRunner`, arcSources, arcTargets, arcDistances, numNodes)
}

#' @rdname Maximum-Mean-Cycle-Algorithms
#' @description `HartmannOrlinMmcRunner` runs Hartmann-Orlin's algorithm to find a directed cycle of minimum mean cost .
HartmannOrlinMmcRunner <- function(arcSources, arcTargets, arcDistances, numNodes) {
    .Call(`_rlemon_HartmannOrlinMmcRunner`, arcSources, arcTargets, arcDistances, numNodes)
}

#' MST Algorithms
#' @name Minimum-Spanning-Tree-Algorithms
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcDistances Vector corresponding to the distances of nodes of a graph's edges
#' @param numNodes The number of nodes in the graph
#' @return A list containing three entries: 1) Two vectors corresponding the source and target nodes of the edges in the tree, and 2) the total minimum spanning tree value.
NULL

#' Arborescence Algorithms
#' @name Minimum-Cost-Arborescence-Algorithms
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcDistances Vector corresponding to the distances of nodes of a graph's edges
#' @param sourceNode The source node
#' @param numNodes The number of nodes in the graph
#' @return A list containing three entries: 1) Two vectors corresponding the source and target nodes of the edges in the tree, and 2) the total cost of the arborescence.
NULL

#' @rdname Minimum-Spanning-Tree-Algorithms
KruskalRunner <- function(arcSources, arcTargets, arcDistances, numNodes) {
    .Call(`_rlemon_KruskalRunner`, arcSources, arcTargets, arcDistances, numNodes)
}

#' @rdname Minimum-Cost-Arborescence-Algorithms
MinCostArborescenceRunner <- function(arcSources, arcTargets, arcDistances, sourceNode, numNodes) {
    .Call(`_rlemon_MinCostArborescenceRunner`, arcSources, arcTargets, arcDistances, sourceNode, numNodes)
}

#' Planar Embedding Algorithms
#' @name Planar-Embedding-Algorithms
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @param numNodes, the number of nodes in the graph
#' @return assorted values, depending on the function
NULL

#' Planar Embedding Algorithms
#' @name Planar-Embedding-Algorithms-2
#' @param arcSources, a vector corresponding to the source nodes of a graph's edges
#' @param arcTargets, a vector corresponding to the destination nodes of a graph's edges
#' @param numNodes, the number of nodes in the graph
#' @return A list containing the following 1) A boolean if the graph is planar or not, 2) start/end node lists for the vertices in the order of the Planar Embedding (if planar), 3) start/end node lists for the arcs in the kuratowski subdivision (if not planar)
NULL

#' @rdname Planar-Embedding-Algorithms
#' @description `PlanarCheckingRunner` returns a boolean stating if a graph is planar or not.
PlanarCheckingRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_PlanarCheckingRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Planar-Embedding-Algorithms-2
#' @description `PlanarEmbeddingRunner` runs the Planar Embedding Algorithm to prove that some graph is planar or not.
PlanarEmbeddingRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_PlanarEmbeddingRunner`, arcSources, arcTargets, numNodes)
}

#' @rdname Planar-Embedding-Algorithms
#' @description `PlanarColoringRunner` returns a List containing 1) a Boolean stating if a graph is planar or not, 2) a vector containing the colors of each node, represented as integers
#' @param useFiveAlg, a boolean that asks if you want to 5-color a graph. If false, runs a faster 6-coloring algorithm instead.
PlanarColoringRunner <- function(arcSources, arcTargets, numNodes, useFiveAlg = TRUE) {
    .Call(`_rlemon_PlanarColoringRunner`, arcSources, arcTargets, numNodes, useFiveAlg)
}

#' @rdname Planar-Embedding-Algorithms
#' @description `PlanarCheckingRunner` returns a List containing 1) a boolean stating if a graph is planar or not, 2) a vector containing the x-coordinates of each node and 3) a vector containing the y-coordinates of each node
PlanarDrawingRunner <- function(arcSources, arcTargets, numNodes) {
    .Call(`_rlemon_PlanarDrawingRunner`, arcSources, arcTargets, numNodes)
}

#' Shortest Path Algorithms - Distance
#' @name Shortest-Path-Algorithms-1
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcDistances Vector corresponding to the distances of a graph's edges
#' @param numNodes The number of nodes in the graph
#' @param startNode The start node of the path
#' @return A list containing two entries: 1) the distances from each node to the startNode and 2) the predecessor of each vertex in its shortest path.
NULL

#' Shortest Path Algorithms - Paths
#' @name Shortest-Path-Algorithms-2
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcDistances Vector corresponding to the distances of a graph's edges
#' @param numNodes The number of nodes in the graph
#' @param startNode The start node of the path
#' @param endNode The end node of the path
#' @return A list containing two entries: 1) the number of arc disjoint paths from the start node to the end node and 2) a list of paths found.
NULL

#' @rdname Shortest-Path-Algorithms-2
#' @description `SuurballeRunner` calculates the shortest path between a specified start and end node and returns a list containing  1) the number of arc disjoint paths from the start node to the end node and 2) a list of paths found.
SuurballeRunner <- function(arcSources, arcTargets, arcDistances, numNodes, startNode, endNode) {
    .Call(`_rlemon_SuurballeRunner`, arcSources, arcTargets, arcDistances, numNodes, startNode, endNode)
}

#' @rdname Shortest-Path-Algorithms-1
#' @description `DijkstraRunner` calculates the shortest path from the start node to each node in the graph and returns a list containing 1) the distances from each node to the startNode and 2) the predecessor of each vertex in its shortest path.
DijkstraRunner <- function(arcSources, arcTargets, arcDistances, numNodes, startNode) {
    .Call(`_rlemon_DijkstraRunner`, arcSources, arcTargets, arcDistances, numNodes, startNode)
}

#' @rdname Shortest-Path-Algorithms-1
#' @description `BellmanFordRunner` calculates the shortest path from the start node to each node in the graph and returns a list containing 1) the distances from each node to the startNode and 2) the predecessor of each vertex in its shortest path.
BellmanFordRunner <- function(arcSources, arcTargets, arcDistances, numNodes, startNode) {
    .Call(`_rlemon_BellmanFordRunner`, arcSources, arcTargets, arcDistances, numNodes, startNode)
}

#' Traveling Salesperson Algorithms on Full Graphs
#' @name TSP-Algorithms
#' @param arcSources Vector corresponding to the source nodes of a graph's edges
#' @param arcTargets Vector corresponding to the destination nodes of a graph's edges
#' @param arcDistances Vector corresponding to the distances of a graph's edges
#' @param numNodes The number of nodes in the graph
#' @param defaultEdgeWeight The default edge weight if an edge is not-specified (default value 999999)
#' @return A list with 1) the list of tour vertices, and 2) the total tour cost
NULL

#' @rdname TSP-Algorithms
#' @description `ChristofidesRunner` runs the Christofides Heuristic
ChristofidesRunner <- function(arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight = 999999L) {
    .Call(`_rlemon_ChristofidesRunner`, arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight)
}

#' @rdname TSP-Algorithms
#' @description `GreedyTSPRunner` runs the Greedy Heuristic
GreedyTSPRunner <- function(arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight = 999999L) {
    .Call(`_rlemon_GreedyTSPRunner`, arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight)
}

#' @rdname TSP-Algorithms
#' @description `InsertionTSPRunner` runs the Insertion Heuristic
InsertionTSPRunner <- function(arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight = 999999L) {
    .Call(`_rlemon_InsertionTSPRunner`, arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight)
}

#' @rdname TSP-Algorithms
#' @description `NearestNeighborTSPRunner` runs the Nearest-Neighbor Heuristic
NearestNeighborTSPRunner <- function(arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight = 999999L) {
    .Call(`_rlemon_NearestNeighborTSPRunner`, arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight)
}

#' @rdname TSP-Algorithms
#' @description `Opt2TSPRunner` runs a 2-OPT heuristic
Opt2TSPRunner <- function(arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight = 999999L) {
    .Call(`_rlemon_Opt2TSPRunner`, arcSources, arcTargets, arcDistances, numNodes, defaultEdgeWeight)
}

