% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn.R
\name{fn_fmls}
\alias{fn_fmls}
\alias{fn_fmls_names}
\alias{fn_fmls_syms}
\title{Extract arguments from a function}
\usage{
fn_fmls(fn = caller_fn())

fn_fmls_names(fn = caller_fn())

fn_fmls_syms(fn = caller_fn())
}
\arguments{
\item{fn}{A function. It is lookep up in the calling frame if not
supplied.}
}
\description{
\code{fn_fmls()} returns a named list of formal arguments.
\code{fn_fmls_names()} returns the names of the arguments.
\code{fn_fmls_syms()} returns formals as a named list of symbols. This
is especially useful for forwarding arguments in \link[=lang]{constructed
calls}.
}
\details{
Unlike \code{formals()}, these helpers also work with primitive
functions. See \code{\link[=is_function]{is_function()}} for a discussion of primitive and
closure functions.
}
\examples{
# Extract from current call:
fn <- function(a = 1, b = 2) fn_fmls()
fn()

# Works with primitive functions:
fn_fmls(base::switch)

# fn_fmls_syms() makes it easy to forward arguments:
lang("apply", !!! fn_fmls_syms(lapply))
}
\seealso{
\code{\link[=lang_args]{lang_args()}} and \code{\link[=lang_args_names]{lang_args_names()}}
}
