/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReassignPartitionsCommand$
implements Logging,
ScalaObject {
    public static final ReassignPartitionsCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1 = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        int actions = Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts$1.generateOpt(), opts$1.executeOpt(), opts$1.verifyOpt()})).count(new anonfun.1(opts$1));
        if (actions != 1) {
            opts$1.parser().printHelpOn(System.err);
            Utils$.MODULE$.croak("Command must include exactly one action: --generate, --execute or --verify");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts$1.parser(), opts$1.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts$1.zkConnectOpt()}));
        String zkConnect = opts$1.options().valueOf(opts$1.zkConnectOpt());
        ZkClient zkClient = new ZkClient(zkConnect, 30000, 30000, ZKStringSerializer$.MODULE$);
        try {
            if (opts$1.options().has(opts$1.verifyOpt())) {
                this.verifyAssignment(zkClient, opts$1);
            } else if (opts$1.options().has(opts$1.generateOpt())) {
                this.generateAssignment(zkClient, opts$1);
            } else if (opts$1.options().has(opts$1.executeOpt())) {
                this.executeAssignment(zkClient, opts$1);
            }
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println(new StringBuilder().append((Object)"Partitions reassignment failed due to ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println(Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    public void verifyAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
            opts.parser().printHelpOn(System.err);
            Utils$.MODULE$.croak("If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
        }
        String jsonFile = opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils$.MODULE$.readFileAsString(jsonFile, Utils$.MODULE$.readFileAsString$default$2());
        Map<TopicAndPartition, Seq<Integer>> partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentData(jsonString);
        Predef$.MODULE$.println("Status of partition reassignment:");
        Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfReassignmentSucceeded(zkClient, partitionsToBeReassigned);
        reassignedPartitionsStatus.foreach(new anonfun.verifyAssignment.1());
    }

    public void generateAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
            opts.parser().printHelpOn(System.err);
            Utils$.MODULE$.croak("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
        }
        String topicsToMoveJsonFile = opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign$1 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(opts.options().valueOf(opts.brokerListOpt())).split(',')).map(new anonfun.2(), Array$.MODULE$.canBuildFrom(Manifest$.MODULE$.Int()));
        String topicsToMoveJsonString = Utils$.MODULE$.readFileAsString(topicsToMoveJsonFile, Utils$.MODULE$.readFileAsString$default$2());
        Seq<String> topicsToReassign = ZkUtils$.MODULE$.parseTopicsData(topicsToMoveJsonString);
        scala.collection.mutable.Map<TopicAndPartition, Seq<Integer>> topicPartitionsToReassign = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, topicsToReassign);
        ObjectRef partitionsToBeReassigned$2 = new ObjectRef(new HashMap());
        scala.collection.immutable.Map groupedByTopic = topicPartitionsToReassign.groupBy(new anonfun.3());
        groupedByTopic.foreach(new anonfun.generateAssignment.1(brokerListToReassign$1, partitionsToBeReassigned$2));
        scala.collection.mutable.Map<TopicAndPartition, Seq<Integer>> currentPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, ((IterableLike)((Map)partitionsToBeReassigned$2.elem).map(new anonfun.4(), Iterable$.MODULE$.canBuildFrom())).toSeq());
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData(currentPartitionReplicaAssignment)})));
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n\n%s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map)partitionsToBeReassigned$2.elem)})));
    }

    public void executeAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile;
        String reassignmentJsonString;
        Map<TopicAndPartition, Seq<Integer>> partitionsToBeReassigned;
        if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
            opts.parser().printHelpOn(System.err);
            Utils$.MODULE$.croak("If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
        }
        if ((partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentData(reassignmentJsonString = Utils$.MODULE$.readFileAsString(reassignmentJsonFile = opts.options().valueOf(opts.reassignmentJsonFileOpt()), Utils$.MODULE$.readFileAsString$default$2()))).isEmpty()) {
            throw new AdminCommandFailedException(Predef$.MODULE$.augmentString("Partition reassignment data file %s is empty").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{reassignmentJsonFile})));
        }
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, partitionsToBeReassigned);
        scala.collection.mutable.Map<TopicAndPartition, Seq<Integer>> currentPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, ((IterableLike)partitionsToBeReassigned.map(new anonfun.5(), Iterable$.MODULE$.canBuildFrom())).toSeq());
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData(currentPartitionReplicaAssignment)})));
        if (reassignPartitionsCommand.reassignPartitions()) {
            Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Successfully started reassignment of partitions %s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData(partitionsToBeReassigned)})));
        } else {
            Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Failed to reassign partitions %s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{partitionsToBeReassigned})));
        }
    }

    private Map<TopicAndPartition, ReassignmentStatus> checkIfReassignmentSucceeded(ZkClient zkClient$1, Map<TopicAndPartition, Seq<Integer>> partitionsToBeReassigned$1) {
        Map partitionsBeingReassigned$1 = ZkUtils$.MODULE$.getPartitionsBeingReassigned(zkClient$1).mapValues(new anonfun.6());
        return partitionsToBeReassigned$1.map(new anonfun.checkIfReassignmentSucceeded.1(zkClient$1, partitionsToBeReassigned$1, partitionsBeingReassigned$1), Map$.MODULE$.canBuildFrom());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkClient zkClient, TopicAndPartition topicAndPartition, Seq<Integer> reassignedReplicas, Map<TopicAndPartition, Seq<Integer>> partitionsToBeReassigned, Map<TopicAndPartition, Seq<Integer>> partitionsBeingReassigned) {
        Option option;
        block7: {
            ReassignmentStatus reassignmentStatus;
            block6: {
                Seq<Integer> assignedReplicas;
                Seq newReplicas;
                block5: {
                    newReplicas = (Seq)partitionsToBeReassigned.apply(topicAndPartition);
                    option = partitionsBeingReassigned.get(topicAndPartition);
                    if (!(option instanceof Some)) break block5;
                    reassignmentStatus = ReassignmentInProgress$.MODULE$;
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                Seq<Integer> seq2 = assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(zkClient, topicAndPartition.topic(), topicAndPartition.partition());
                Seq seq3 = newReplicas;
                if (!(seq2 != null ? !seq2.equals(seq3) : seq3 != null)) {
                    reassignmentStatus = ReassignmentCompleted$.MODULE$;
                } else {
                    Predef$.MODULE$.println(Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{assignedReplicas.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                    reassignmentStatus = ReassignmentFailed$.MODULE$;
                }
            }
            return reassignmentStatus;
        }
        throw new MatchError(option);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

